/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenCocobolo
extends WorldGenTree {
    public WorldGenCocobolo(ITreeGenData tree) {
        super(tree, 8, 8);
    }

    @Override
    public void generate(World world) {
        List<ChunkCoordinates> treeTops = this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height;
        for (ChunkCoordinates treeTop : treeTops) {
            this.addLeaf(world, treeTop.posX, treeTop.posY + 1, treeTop.posZ, WorldGenBase.EnumReplaceMode.NONE);
        }
        int n = --leafSpawn;
        --leafSpawn;
        this.generateAdjustedCylinder(world, n, 1.0f, 1, this.leaf);
        if (this.height > 10) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(world, leafSpawn, 0.0f, 1, this.leaf);
        --leafSpawn;
        while (leafSpawn > 4) {
            int offset = 1;
            if (leafSpawn % 2 == 0) {
                if (world.rand.nextBoolean()) {
                    offset = -1;
                }
                this.generateAdjustedCylinder(world, leafSpawn, offset, offset, 2.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
            } else {
                if (world.rand.nextBoolean()) {
                    offset = -1;
                }
                this.generateAdjustedCylinder(world, leafSpawn, offset, offset, 0.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
            }
            --leafSpawn;
        }
    }
}

