/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumPostage;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.IStamps;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.config.ForestryItem;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SlotUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.EnumStationState;
import forestry.mail.Letter;
import forestry.mail.MailAddress;
import forestry.mail.items.ItemLetter;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class TradeStation
extends WorldSavedData
implements ITradeStation,
IInventoryAdapter {
    public static final String SAVE_NAME = "TradePO_";
    public static final short SLOT_TRADEGOOD = 0;
    public static final short SLOT_TRADEGOOD_COUNT = 1;
    public static final short SLOT_EXCHANGE_1 = 1;
    public static final short SLOT_EXCHANGE_COUNT = 4;
    public static final short SLOT_LETTERS_1 = 5;
    public static final short SLOT_LETTERS_COUNT = 6;
    public static final short SLOT_STAMPS_1 = 11;
    public static final short SLOT_STAMPS_COUNT = 4;
    public static final short SLOT_RECEIVE_BUFFER = 15;
    public static final short SLOT_RECEIVE_BUFFER_COUNT = 15;
    public static final short SLOT_SEND_BUFFER = 30;
    public static final short SLOT_SEND_BUFFER_COUNT = 10;
    public static final int SLOT_SIZE = 40;
    private GameProfile owner;
    private IMailAddress address;
    private boolean isVirtual = false;
    private boolean isInvalid = false;
    private final InventoryAdapter inventory = new TradeStationInventory();

    public TradeStation(GameProfile owner, IMailAddress address) {
        super(SAVE_NAME + address);
        if (!address.isTrader()) {
            throw new IllegalArgumentException("TradeStation address must be a trader");
        }
        this.owner = owner;
        this.address = address;
    }

    public TradeStation(String savename) {
        super(savename);
    }

    @Override
    public IMailAddress getAddress() {
        return this.address;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.hasKey("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.getCompoundTag("owner"));
        }
        if (nbttagcompound.hasKey("address")) {
            this.address = MailAddress.loadFromNBT(nbttagcompound.getCompoundTag("address"));
        }
        this.isVirtual = nbttagcompound.getBoolean("VRT");
        this.isInvalid = nbttagcompound.getBoolean("IVL");
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbt;
        if (this.owner != null) {
            nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.setTag("owner", (NBTBase)nbt);
        }
        if (this.address != null) {
            nbt = new NBTTagCompound();
            this.address.writeToNBT(nbt);
            nbttagcompound.setTag("address", (NBTBase)nbt);
        }
        nbttagcompound.setBoolean("VRT", this.isVirtual);
        nbttagcompound.setBoolean("IVL", this.isInvalid);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public boolean isValid() {
        return !this.isInvalid;
    }

    @Override
    public void invalidate() {
        this.isInvalid = true;
    }

    @Override
    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
        this.markDirty();
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public TradeStationInfo getTradeInfo() {
        ItemStack[] condensedRequired = ItemStackUtil.condenseStacks(InventoryUtil.getStacks((IInventory)this.inventory, 1, 4));
        EnumStationState state = EnumStationState.OK;
        if (!this.isVirtual()) {
            if (!this.hasPaper(2)) {
                state = EnumStationState.INSUFFICIENT_PAPER;
            }
            if (!this.canPayPostage(3)) {
                state = EnumStationState.INSUFFICIENT_STAMPS;
            }
            if (this.countFillableOrders(1, this.inventory.getStackInSlot(0)) <= 0) {
                state = EnumStationState.INSUFFICIENT_TRADE_GOOD;
            }
        }
        return new TradeStationInfo(this.address, this.owner, this.inventory.getStackInSlot(0), condensedRequired, state);
    }

    @Override
    public IPostalState handleLetter(World world, IMailAddress recipient, ItemStack letterstack, boolean doLodge) {
        boolean sendOwnerNotice = doLodge && this.owner != null;
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        if (!this.isVirtual() && !this.hasPaper(sendOwnerNotice ? 2 : 1)) {
            return EnumStationState.INSUFFICIENT_PAPER;
        }
        int ordersToFill = ItemStackUtil.containsSets(InventoryUtil.getStacks((IInventory)this.inventory, 1, 4), letter.getAttachments());
        if (ordersToFill <= 0) {
            return EnumStationState.INSUFFICIENT_OFFER;
        }
        if (!this.isVirtual()) {
            int storable;
            int fillable = this.countFillableOrders(ordersToFill, this.inventory.getStackInSlot(0));
            if (fillable <= 0) {
                return EnumStationState.INSUFFICIENT_TRADE_GOOD;
            }
            if (fillable < ordersToFill) {
                ordersToFill = fillable;
            }
            if ((storable = this.countStorablePayment(ordersToFill, InventoryUtil.getStacks((IInventory)this.inventory, 1, 4))) <= 0) {
                return EnumStationState.INSUFFICIENT_BUFFER;
            }
            if (storable < ordersToFill) {
                ordersToFill = storable;
            }
        }
        Letter mail = new Letter(this.address, letter.getSender());
        mail.setText("Please find your order attached.");
        for (int i = 0; i < ordersToFill; ++i) {
            mail.addAttachment(this.inventory.getStackInSlot(0).copy());
        }
        mail.addAttachments(this.getSurplusAttachments(ordersToFill, letter.getAttachments()));
        int requiredPostage = mail.requiredPostage();
        if (!this.isVirtual() && !this.canPayPostage(requiredPostage + (sendOwnerNotice ? 1 : 0))) {
            return EnumStationState.INSUFFICIENT_STAMPS;
        }
        int[] stampCount = this.getPostage(requiredPostage, this.isVirtual());
        for (int i = 0; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            mail.addStamps(ForestryItem.stamps.getItemStack(stampCount[i], EnumPostage.values()[i].ordinal() - 1));
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        mail.writeToNBT(nbttagcompound);
        ItemStack mailstack = ItemLetter.createStampedLetterStack(mail);
        mailstack.setTagCompound(nbttagcompound);
        IPostalState responseState = PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, mailstack, doLodge);
        if (!responseState.isOk()) {
            return EnumDeliveryState.RESPONSE_NOT_MAILABLE;
        }
        for (int i = 0; i < ordersToFill; ++i) {
            for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.inventory, 1, 4)) {
                if (stack == null) continue;
                InventoryUtil.tryAddStack((IInventory)this.inventory, stack.copy(), 15, 15, false);
            }
        }
        this.removePaper();
        this.removeStamps(stampCount);
        this.removeTradegood(ordersToFill);
        if (sendOwnerNotice) {
            nbttagcompound = new NBTTagCompound();
            Letter confirm = new Letter(this.address, new MailAddress(this.owner));
            confirm.setText(ordersToFill + " order(s) from " + letter.getSender().getName() + " were filled.");
            confirm.addStamps(ForestryItem.stamps.getItemStack(1, EnumPostage.P_1.ordinal() - 1));
            confirm.writeToNBT(nbttagcompound);
            ItemStack confirmstack = ItemLetter.createStampedLetterStack(confirm);
            confirmstack.setTagCompound(nbttagcompound);
            PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, confirmstack, doLodge);
            this.removePaper();
            this.removeStamps(new int[]{0, 1});
        }
        this.markDirty();
        return EnumDeliveryState.OK;
    }

    private int countFillableOrders(int max, ItemStack tradegood) {
        if (tradegood == null) {
            return 0;
        }
        float orderCount = 0.0f;
        for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.inventory, 30, 10)) {
            if (stack == null || !stack.isItemEqual(tradegood) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)tradegood) || !((orderCount += (float)stack.stackSize / (float)tradegood.stackSize) >= (float)max)) continue;
            return max;
        }
        return (int)Math.floor(orderCount);
    }

    public boolean canReceivePayment() {
        InventoryAdapter test = this.inventory.copy();
        ItemStack[] payment = InventoryUtil.getStacks((IInventory)this.inventory, 1, 4);
        return InventoryUtil.tryAddStacksCopy((IInventory)test, payment, 15, 15, true);
    }

    private int countStorablePayment(int max, ItemStack[] exchange) {
        InventoryAdapter test = this.inventory.copy();
        int count = 0;
        for (int i = 0; i < max && InventoryUtil.tryAddStacksCopy((IInventory)test, exchange, 15, 15, true); ++i) {
            ++count;
        }
        return count;
    }

    private void removeTradegood(int filled) {
        block0: for (int j = 0; j < filled; ++j) {
            int toRemove = this.inventory.getStackInSlot((int)0).stackSize;
            for (int i = 30; i < 40; ++i) {
                ItemStack buffer = this.inventory.getStackInSlot(i);
                if (buffer == null || !buffer.isItemEqual(this.inventory.getStackInSlot(0)) || !ItemStack.areItemStackTagsEqual((ItemStack)buffer, (ItemStack)this.inventory.getStackInSlot(0))) continue;
                ItemStack decrease = this.inventory.decrStackSize(i, toRemove);
                if ((toRemove -= decrease.stackSize) <= 0) continue block0;
            }
        }
    }

    private boolean hasPaper(int amountRequired) {
        int amountFound = 0;
        for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.inventory, 5, 6)) {
            if (stack != null) {
                amountFound += stack.stackSize;
            }
            if (amountFound < amountRequired) continue;
            return true;
        }
        return false;
    }

    private void removePaper() {
        for (int i = 5; i < 11; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() != Items.paper || stack.stackSize <= 0) continue;
            this.inventory.decrStackSize(i, 1);
            break;
        }
    }

    private boolean canPayPostage(int postage) {
        int posted = 0;
        for (ItemStack stamp : InventoryUtil.getStacks((IInventory)this.inventory, 11, 4)) {
            if (stamp == null || !(stamp.getItem() instanceof IStamps) || (posted += ((IStamps)stamp.getItem()).getPostage(stamp).getValue() * stamp.stackSize) < postage) continue;
            return true;
        }
        return false;
    }

    private int[] getPostage(int postage, boolean virtual) {
        int[] stamps = new int[EnumPostage.values().length];
        for (int i = EnumPostage.values().length - 1; i > 0 && postage > 0; --i) {
            int max;
            EnumPostage postValue = EnumPostage.values()[i];
            if (postValue.getValue() > postage) continue;
            int num = 99;
            if (!virtual) {
                num = this.getNumStamps(postValue);
            }
            if ((max = (int)Math.floor(postage / postValue.getValue())) < num) {
                num = max;
            }
            stamps[i] = num;
            postage -= num * postValue.getValue();
        }
        return stamps;
    }

    private int getNumStamps(EnumPostage postage) {
        int count = 0;
        for (ItemStack stamp : InventoryUtil.getStacks((IInventory)this.inventory, 11, 4)) {
            if (stamp == null || !(stamp.getItem() instanceof IStamps) || ((IStamps)stamp.getItem()).getPostage(stamp) != postage) continue;
            count += stamp.stackSize;
        }
        return count;
    }

    private void removeStamps(int[] stampCount) {
        for (int i = 1; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            for (int j = 11; j < 15; ++j) {
                ItemStack stamp;
                if (stampCount[i] <= 0 || (stamp = this.inventory.getStackInSlot(j)) == null || !(stamp.getItem() instanceof IStamps) || ((IStamps)stamp.getItem()).getPostage(stamp) != EnumPostage.values()[i]) continue;
                ItemStack decrease = this.inventory.decrStackSize(j, stampCount[i]);
                int n = i;
                stampCount[n] = stampCount[n] - decrease.stackSize;
            }
        }
    }

    private ItemStack[] getSurplusAttachments(int filled, ItemStack[] attachments) {
        int i;
        ArrayList<ItemStack> surplus = new ArrayList<ItemStack>();
        ItemStack[] pool = new ItemStack[attachments.length];
        for (i = 0; i < attachments.length; ++i) {
            if (attachments[i] == null) continue;
            pool[i] = attachments[i].copy();
        }
        for (i = 0; i < filled; ++i) {
            ItemStack[] condensedRequired;
            ItemStack[] required = InventoryUtil.getStacks((IInventory)this.inventory, 1, 4);
            for (ItemStack req : condensedRequired = ItemStackUtil.condenseStacks(required)) {
                for (int j = 0; j < pool.length; ++j) {
                    ItemStack pol = pool[j];
                    if (pol == null || !pol.isItemEqual(req)) continue;
                    if (req.stackSize >= pol.stackSize) {
                        req.stackSize -= pol.stackSize;
                        pool[j] = null;
                        continue;
                    }
                    pol.stackSize -= req.stackSize;
                    req.stackSize = 0;
                }
            }
        }
        for (ItemStack stack : pool) {
            if (stack == null) continue;
            surplus.add(stack);
        }
        return surplus.toArray(new ItemStack[surplus.size()]);
    }

    public void markDirty() {
        super.markDirty();
        this.inventory.markDirty();
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack) {
        this.markDirty();
        this.inventory.setInventorySlotContents(slot, itemStack);
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlot(int var1) {
        return this.inventory.getStackInSlot(var1);
    }

    public ItemStack decrStackSize(int var1, int var2) {
        return this.inventory.decrStackSize(var1, var2);
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return this.inventory.getStackInSlotOnClosing(var1);
    }

    public String getInventoryName() {
        return this.inventory.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        return this.inventory.isItemValidForSlot(i, itemStack);
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return this.inventory.getAccessibleSlotsFromSide(side);
    }

    public boolean canInsertItem(int slot, ItemStack itemStack, int side) {
        return this.inventory.canInsertItem(slot, itemStack, side);
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
        return this.inventory.canExtractItem(slot, itemStack, side);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.inventory.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.inventory.isLocked(slotIndex);
    }

    public static class TradeStationInventory
    extends InventoryAdapter {
        public TradeStationInventory() {
            super(40, "INV");
        }

        @Override
        public int[] getAccessibleSlotsFromSide(int side) {
            int i;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (i = 5; i < 11; ++i) {
                slots.add(i);
            }
            for (i = 11; i < 15; ++i) {
                slots.add(i);
            }
            for (i = 15; i < 30; ++i) {
                slots.add(i);
            }
            for (i = 30; i < 40; ++i) {
                slots.add(i);
            }
            int[] slotsInt = new int[slots.size()];
            for (int i2 = 0; i2 < slots.size(); ++i2) {
                slotsInt[i2] = (Integer)slots.get(i2);
            }
            return slotsInt;
        }

        @Override
        public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
            return SlotUtil.isSlotInRange(slot, 15, 15);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (SlotUtil.isSlotInRange(slotIndex, 30, 10)) {
                for (int i = 0; i < 1; ++i) {
                    ItemStack tradeGood = this.getStackInSlot(0 + i);
                    if (!ItemStackUtil.isIdenticalItem(tradeGood, itemStack)) continue;
                    return true;
                }
                return false;
            }
            if (SlotUtil.isSlotInRange(slotIndex, 5, 6)) {
                Item item = itemStack.getItem();
                return item == Items.paper;
            }
            if (SlotUtil.isSlotInRange(slotIndex, 11, 4)) {
                Item item = itemStack.getItem();
                return item instanceof IStamps;
            }
            return false;
        }

        @Override
        public boolean isItemValidForSlot(int i, ItemStack itemstack) {
            return this.canSlotAccept(i, itemstack);
        }
    }
}

