/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmComponent;
import forestry.core.utils.vect.MutableVect;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmHelper {
    public static final ImmutableSet<Block> bricks = ImmutableSet.of((Object)Blocks.brick_block, (Object)Blocks.stonebrick, (Object)Blocks.sandstone, (Object)Blocks.nether_brick, (Object)Blocks.quartz_block);

    private static FarmDirection getOpposite(FarmDirection farmDirection) {
        ForgeDirection forgeDirection = farmDirection.getForgeDirection();
        ForgeDirection forgeDirectionOpposite = forgeDirection.getOpposite();
        return FarmDirection.getFarmDirection(forgeDirectionOpposite);
    }

    public static Vect getFarmMultiblockCorner(World world, Vect start, FarmDirection farmSide, FarmDirection layoutDirection) {
        Vect edge = FarmHelper.getFarmMultiblockEdge(world, start, farmSide);
        return FarmHelper.getFarmMultiblockEdge(world, edge, FarmHelper.getOpposite(layoutDirection));
    }

    private static Vect getFarmMultiblockEdge(World world, Vect start, FarmDirection direction) {
        MutableVect edge = new MutableVect(start);
        while (VectUtil.getTile(world, edge) instanceof IFarmComponent) {
            edge.add(direction);
        }
        edge.add(FarmHelper.getOpposite(direction));
        return new Vect(edge);
    }
}

