/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TileCarpenter
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IItemStackDisplay {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_CRAFTING_COUNT = 9;
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_PRODUCT_COUNT = 1;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final TileInventoryAdapter craftingInventory;
    private final InventoryCraftResult craftPreviewInventory;
    @Nullable
    private ICarpenterRecipe currentRecipe;
    private int packageTime;
    private int totalTime;
    private ItemStack pendingProduct;

    private ItemStack getBoxStack() {
        return this.getInternalInventory().getStackInSlot(9);
    }

    public TileCarpenter() {
        super(1100, 4000, 200);
        this.setHints(Config.hints.get("carpenter"));
        this.resourceTank = new FilteredTank(10000, CarpenterRecipeManager.recipeFluids);
        this.craftingInventory = new TileInventoryAdapter<TileCarpenter>(this, 10, "CraftItems");
        this.craftPreviewInventory = new InventoryCraftResult();
        this.setInternalInventory(new CarpenterInventoryAdapter(this));
        this.tankManager = new TankManager(this.resourceTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.CarpenterGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("PackageTime", this.packageTime);
        nbttagcompound.setInteger("PackageTotalTime", this.totalTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            NBTTagCompound nbttagcompoundP = new NBTTagCompound();
            this.pendingProduct.writeToNBT(nbttagcompoundP);
            nbttagcompound.setTag("PendingProduct", (NBTBase)nbttagcompoundP);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.packageTime = nbttagcompound.getInteger("PackageTime");
        this.totalTime = nbttagcompound.getInteger("PackageTotalTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("PendingProduct")) {
            NBTTagCompound nbttagcompoundP = nbttagcompound.getCompoundTag("PendingProduct");
            this.pendingProduct = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompoundP);
        }
        this.setCurrentRecipe(CarpenterRecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.worldObj));
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    public void resetRecipe() {
        if (this.worldObj.isRemote) {
            return;
        }
        this.setCurrentRecipe(CarpenterRecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.getWorldObj()));
    }

    private void setCurrentRecipe(@Nullable ICarpenterRecipe currentRecipe) {
        this.currentRecipe = currentRecipe;
        ItemStack craftingResult = currentRecipe != null ? currentRecipe.getCraftingGridRecipe().getRecipeOutput() : null;
        this.craftPreviewInventory.setInventorySlotContents(0, craftingResult);
    }

    @Override
    public void updateServerSide() {
        ICarpenterRecipe recipe;
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        IInventoryAdapter accessibleInventory = this.getInternalInventory();
        if (accessibleInventory.getStackInSlot(11) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)accessibleInventory, 11);
        }
        if (!this.updateOnInterval(40)) {
            return;
        }
        if (this.currentRecipe == null && (recipe = CarpenterRecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.worldObj)) != null) {
            this.setCurrentRecipe(recipe);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
        errorLogic.setCondition(!this.validateResources(), EnumErrorCode.NORESOURCE);
    }

    @Override
    public boolean workCycle() {
        if (this.packageTime > 0) {
            --this.packageTime;
            if (this.currentRecipe == null || !this.validateResources()) {
                this.totalTime = 0;
                this.packageTime = 0;
                return false;
            }
            if (this.packageTime <= 0) {
                this.pendingProduct = this.currentRecipe.getCraftingGridRecipe().getRecipeOutput();
                this.totalTime = 0;
                if (!this.removeResources(this.currentRecipe)) {
                    return false;
                }
                this.resetRecipe();
                return this.tryAddPending();
            }
            return true;
        }
        if (this.pendingProduct != null) {
            return this.tryAddPending();
        }
        if (this.currentRecipe != null) {
            if (!this.validateResources()) {
                return false;
            }
            this.packageTime = this.totalTime = this.currentRecipe.getPackagingTime();
            this.resetRecipe();
            return true;
        }
        return false;
    }

    private boolean validateResources() {
        ItemStack[] stock;
        if (this.currentRecipe == null) {
            return true;
        }
        FluidStack fluid = this.currentRecipe.getFluidResource();
        if (fluid != null && this.resourceTank.getFluidAmount() < fluid.amount) {
            return false;
        }
        IInventoryAdapter accessibleInventory = this.getInternalInventory();
        if (this.currentRecipe.getBox() != null && accessibleInventory.getStackInSlot(9) == null) {
            return false;
        }
        ItemStack[] set = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        return ItemStackUtil.containsSets(set, stock = InventoryUtil.getStacks((IInventory)accessibleInventory, 12, 18), true, false) > 0;
    }

    private boolean removeResources(ICarpenterRecipe recipe) {
        ItemStack removed;
        FluidStack fluid = recipe.getFluidResource();
        if (fluid != null) {
            FluidStack amountDrained = this.resourceTank.drain(fluid.amount, false);
            if (amountDrained != null && amountDrained.amount == fluid.amount) {
                this.resourceTank.drain(fluid.amount, true);
            } else {
                return false;
            }
        }
        if (recipe.getBox() != null && ((removed = this.getInternalInventory().decrStackSize(9, 1)) == null || removed.stackSize == 0)) {
            return false;
        }
        return this.removeSets(1, InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9));
    }

    private boolean removeSets(int count, ItemStack[] set) {
        EntityPlayer player = Proxies.common.getPlayer(this.worldObj, this.getAccessHandler().getOwner());
        return InventoryUtil.removeSets((IInventory)this.getInternalInventory(), count, set, 12, 18, player, true, true);
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        boolean added = InventoryUtil.tryAddStack((IInventory)this, this.pendingProduct, 10, 1, true);
        if (added) {
            this.pendingProduct = null;
        }
        this.getErrorLogic().setCondition(!added, EnumErrorCode.NOSPACE);
        return added;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack product = this.getStackInSlot(10);
        if (product != null && product.getMaxStackSize() - product.stackSize < this.currentRecipe.getCraftingGridRecipe().getRecipeOutput().stackSize) {
            return false;
        }
        return this.validateResources();
    }

    public int getCraftingProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return (this.totalTime - this.packageTime) * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank, this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.packageTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(container, i, this.packageTime);
        iCrafting.sendProgressBarUpdate(container, i + 1, this.totalTime);
    }

    public IInventory getCraftingInventory() {
        return this.craftingInventory;
    }

    public IInventory getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.setInventorySlotContents(0, itemStack);
    }

    public int fill(ForgeDirection direction, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(direction, resource, doFill);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class CarpenterInventoryAdapter
    extends TileInventoryAdapter<TileCarpenter> {
        public CarpenterInventoryAdapter(TileCarpenter carpenter) {
            super(carpenter, 30, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 11) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileCarpenter)this.tile).tankManager.accepts(fluid);
            }
            if (slotIndex == 9) {
                return CarpenterRecipeManager.isBox(itemStack);
            }
            if (this.canSlotAccept(11, itemStack) || this.canSlotAccept(9, itemStack)) {
                return false;
            }
            return SlotUtil.isSlotInRange(slotIndex, 12, 18);
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 10;
        }
    }
}

