/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IClimateControlled;
import forestry.apiculture.BeeHousingInventory;
import forestry.apiculture.multiblock.IAlvearyController;
import forestry.core.access.EnumAccess;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.CoordTriplet;
import forestry.core.multiblock.IMultiblockPart;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockTileEntityBase;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.rectangular.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketGuiUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AlvearyController
extends RectangularMultiblockControllerBase
implements IAlvearyController,
IClimateControlled {
    private final BeeHousingInventory inventory;
    private final IBeekeepingLogic beekeepingLogic;
    private BiomeGenBase cachedBiome;
    private float tempChange = 0.0f;
    private float humidChange = 0.0f;
    private final Set<IBeeModifier> beeModifiers = new HashSet<IBeeModifier>();
    private final Set<IBeeListener> beeListeners = new HashSet<IBeeListener>();
    private final Set<IAlvearyComponent.Climatiser> climatisers = new HashSet<IAlvearyComponent.Climatiser>();
    private final Set<IAlvearyComponent.Active> activeComponents = new HashSet<IAlvearyComponent.Active>();
    private final Set<IAlvearyComponent> allComponents = new HashSet<IAlvearyComponent>();
    private int breedingProgressPercent = 0;

    public AlvearyController(World world) {
        super(world);
        this.inventory = new BeeHousingInventory(9, "Items", this.getAccessHandler());
        this.beekeepingLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
        this.beeModifiers.add(new AlvearyBeeModifier());
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beekeepingLogic;
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return this.beeListeners;
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return this.beeModifiers;
    }

    @Override
    public Iterable<IAlvearyComponent> getComponents() {
        return this.allComponents;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof IAlvearyComponent) {
            this.allComponents.add((IAlvearyComponent)((Object)newPart));
            if (newPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)((Object)newPart);
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.add(beeModifier);
            }
            if (newPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)((Object)newPart);
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.add(beeListener);
            }
            if (newPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.add((IAlvearyComponent.Climatiser)((Object)newPart));
            }
            if (newPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.add((IAlvearyComponent.Active)((Object)newPart));
            }
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof IAlvearyComponent) {
            this.allComponents.remove((Object)oldPart);
            if (oldPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)((Object)oldPart);
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.remove(beeModifier);
            }
            if (oldPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)((Object)oldPart);
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.remove(beeListener);
            }
            if (oldPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.remove((Object)oldPart);
            }
            if (oldPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.remove((Object)oldPart);
            }
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        super.isMachineWhole();
        CoordTriplet maximumCoord = this.getMaximumCoord();
        CoordTriplet minimumCoord = this.getMinimumCoord();
        int slabY = maximumCoord.y + 1;
        for (int slabX = minimumCoord.x; slabX <= maximumCoord.x; ++slabX) {
            for (int slabZ = minimumCoord.z; slabZ <= maximumCoord.z; ++slabZ) {
                Block block = this.worldObj.getBlock(slabX, slabY, slabZ);
                if (!BlockUtil.isWoodSlabBlock(block)) {
                    throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.alveary.error.needSlabs"));
                }
                int meta = this.worldObj.getBlockMetadata(slabX, slabY, slabZ);
                if ((meta & 8) == 0) continue;
                throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.alveary.error.needSlabs"));
            }
        }
        int airY = maximumCoord.y;
        for (int airX = minimumCoord.x - 1; airX <= maximumCoord.x + 1; ++airX) {
            for (int airZ = minimumCoord.z - 1; airZ <= maximumCoord.z + 1; ++airZ) {
                Block block;
                if (this.isCoordInMultiblock(airX, airY, airZ) || !(block = this.worldObj.getBlock(airX, airY, airZ)).isOpaqueCube()) continue;
                throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.alveary.error.needSpace"));
            }
        }
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 27;
    }

    @Override
    protected int getMaximumXSize() {
        return 3;
    }

    @Override
    protected int getMaximumZSize() {
        return 3;
    }

    @Override
    protected int getMaximumYSize() {
        return 3;
    }

    @Override
    protected int getMinimumXSize() {
        return 3;
    }

    @Override
    protected int getMinimumYSize() {
        return 3;
    }

    @Override
    protected int getMinimumZSize() {
        return 3;
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase assimilated) {
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateServer(tickCount);
        }
        boolean canWork = this.beekeepingLogic.canWork();
        if (canWork) {
            this.beekeepingLogic.doWork();
        }
        for (IAlvearyComponent.Climatiser climatiser : this.climatisers) {
            climatiser.changeClimate(tickCount, this);
        }
        this.tempChange = AlvearyController.equalizeChange(this.tempChange);
        this.humidChange = AlvearyController.equalizeChange(this.humidChange);
        return canWork;
    }

    private static float equalizeChange(float change) {
        if (change == 0.0f) {
            return 0.0f;
        }
        if ((change *= 0.95f) <= 0.001f && change >= -0.001f) {
            change = 0.0f;
        }
        return change;
    }

    @Override
    protected void updateClient(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateClient(tickCount);
        }
        if (this.beekeepingLogic.canDoBeeFX() && this.updateOnInterval(2)) {
            this.beekeepingLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                CoordTriplet center = this.getCenterCoord();
                float fxX = (float)center.x + 0.5f;
                float fxY = (float)center.y + 1.0f;
                float fxZ = (float)center.z + 0.5f;
                float distanceFromCenter = 1.6f;
                float leftRightSpreadFromCenter = distanceFromCenter * (this.worldObj.rand.nextFloat() - 0.5f);
                float upSpread = this.worldObj.rand.nextFloat() * 0.8f;
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX - distanceFromCenter, fxY += upSpread, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + distanceFromCenter, fxY, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ - distanceFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ + distanceFromCenter);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setFloat("TempChange", this.tempChange);
        data.setFloat("HumidChange", this.humidChange);
        this.beekeepingLogic.writeToNBT(data);
        this.inventory.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tempChange = data.getFloat("TempChange");
        this.humidChange = data.getFloat("HumidChange");
        this.beekeepingLogic.readFromNBT(data);
        this.inventory.readFromNBT(data);
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
        this.beekeepingLogic.syncToClient();
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        CoordTriplet coord = this.getCenterCoord();
        return new ChunkCoordinates(coord.x, coord.y + 1, coord.z);
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        PacketGuiUpdate packet = new PacketGuiUpdate(this);
        Proxies.net.sendNetworkPacket(packet, this.worldObj);
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            for (IMultiblockPart part : this.connectedParts) {
                if (!(part instanceof MultiblockTileEntityBase)) continue;
                MultiblockTileEntityBase tile = (MultiblockTileEntityBase)part;
                tile.notifyNeighborsOfBlockChange();
            }
            this.markDirty();
        }
    }

    @Override
    public float getExactTemperature() {
        CoordTriplet coords = this.getReferenceCoord();
        return this.getBiome().getFloatTemperature(coords.x, coords.y, coords.z) + this.tempChange;
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().rainfall + this.humidChange;
    }

    @Override
    public EnumTemperature getTemperature() {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(this);
        if (beeModifier.isHellish() && this.tempChange >= 0.0f) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public BiomeGenBase getBiome() {
        if (this.cachedBiome == null) {
            CoordTriplet coords = this.getReferenceCoord();
            this.cachedBiome = this.worldObj.getBiomeGenForCoords(coords.x, coords.z);
        }
        return this.cachedBiome;
    }

    @Override
    public int getBlockLightValue() {
        CoordTriplet topCenter = this.getTopCenterCoord();
        return this.worldObj.getBlockLightValue(topCenter.x, topCenter.y + 1, topCenter.z);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        CoordTriplet topCenter = this.getTopCenterCoord();
        return this.worldObj.canBlockSeeTheSky(topCenter.x, topCenter.y + 2, topCenter.z);
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        ChunkCoordinates coordinates = this.getCoordinates();
        float temperature = this.getBiome().getFloatTemperature(coordinates.posX, coordinates.posY, coordinates.posZ);
        this.tempChange += change;
        this.tempChange = Math.max(boundaryDown - temperature, this.tempChange);
        this.tempChange = Math.min(boundaryUp - temperature, this.tempChange);
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        float humidity = this.getBiome().rainfall;
        this.humidChange += change;
        this.humidChange = Math.max(boundaryDown - humidity, this.humidChange);
        this.humidChange = Math.min(boundaryUp - humidity, this.humidChange);
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        super.writeGuiData(data);
        data.writeVarInt(this.beekeepingLogic.getBeeProgressPercent());
        data.writeVarInt(Math.round(this.tempChange * 100.0f));
        data.writeVarInt(Math.round(this.humidChange * 100.0f));
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        super.readGuiData(data);
        this.breedingProgressPercent = data.readVarInt();
        this.tempChange = (float)data.readVarInt() / 100.0f;
        this.humidChange = (float)data.readVarInt() / 100.0f;
    }

    private static class AlvearyBeeModifier
    extends DefaultBeeModifier {
        private AlvearyBeeModifier() {
        }

        @Override
        public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
            return 2.0f;
        }
    }
}

