/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.fluids.Fluids;
import forestry.core.render.EnumTankLevel;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.IFluidTank;

public class TankRenderInfo {
    public static final TankRenderInfo EMPTY = new EmptyTankRenderInfo();
    @Nonnull
    private Color fluidColor;
    @Nonnull
    private EnumTankLevel level;

    public TankRenderInfo(@Nonnull IFluidTank fluidTank, int resourceScaled) {
        this(Fluids.getFluidColor(fluidTank.getFluid()), EnumTankLevel.rateTankLevel(resourceScaled));
    }

    public TankRenderInfo(@Nonnull Color fluidColor, @Nonnull EnumTankLevel level) {
        this.fluidColor = fluidColor;
        this.level = level;
    }

    @Nonnull
    public Color getFluidColor() {
        return this.fluidColor;
    }

    @Nonnull
    public EnumTankLevel getLevel() {
        return this.level;
    }

    public void setFluidColor(@Nonnull Color fluidColor) {
        this.fluidColor = fluidColor;
    }

    public void setLevel(@Nonnull EnumTankLevel level) {
        this.level = level;
    }

    private static class EmptyTankRenderInfo
    extends TankRenderInfo {
        public EmptyTankRenderInfo() {
            super(Fluids.WATER.getColor(), EnumTankLevel.EMPTY);
        }

        @Override
        public void setFluidColor(@Nonnull Color fluidColor) {
        }

        @Override
        public void setLevel(@Nonnull EnumTankLevel level) {
        }
    }
}

