/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.CropBasicFruit;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableBasicFruit
implements IFarmable {
    private final Block block;
    private final int matureMeta;

    public FarmableBasicFruit(Block block, int matureMeta) {
        this.block = block;
        this.matureMeta = matureMeta;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.getBlock(x, y, z) == this.block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z) != this.block) {
            return null;
        }
        if (world.getBlockMetadata(x, y, z) != this.matureMeta) {
            return null;
        }
        return new CropBasicFruit(world, this.block, this.matureMeta, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStackUtil.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return world.setBlock(x, y, z, this.block, 0, 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

