/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import forestry.core.recipes.IDescriptiveRecipe;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiCarpenter;
import forestry.factory.tiles.TileCarpenter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerCarpenter
extends RecipeHandlerBase {
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = GuiCarpenter.class;
        API.setGuiOffset(guiClass, (int)5, (int)14);
    }

    @Override
    public String getRecipeID() {
        return "forestry.carpenter";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory.1.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/carpenter.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(93, 36, 4, 18);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)14, (int)166, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(93, 36, 176, 59, 4, 17, 80, 3);
    }

    @Override
    public void loadAllRecipes() {
        for (TileCarpenter.Recipe recipe : TileCarpenter.RecipeManager.recipes) {
            this.arecipes.add(new CachedCarpenterRecipe(recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (TileCarpenter.Recipe recipe : TileCarpenter.RecipeManager.recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getCraftingResult(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedCarpenterRecipe(recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (TileCarpenter.Recipe recipe : TileCarpenter.RecipeManager.recipes) {
            CachedCarpenterRecipe crecipe = new CachedCarpenterRecipe(recipe);
            if (crecipe.inputs == null || !crecipe.contains(crecipe.inputs, ingred)) continue;
            crecipe.generatePermutations();
            crecipe.setIngredientPermutation(crecipe.inputs, ingred);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (TileCarpenter.Recipe recipe : TileCarpenter.RecipeManager.recipes) {
            if (!NEIUtils.areFluidsSameType(recipe.getLiquid(), ingredient)) continue;
            this.arecipes.add(new CachedCarpenterRecipe(recipe, true));
        }
    }

    public class CachedCarpenterRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedFluidTank tank;
        public PositionedStack output;

        public CachedCarpenterRecipe(TileCarpenter.Recipe recipe, boolean genPerms) {
            IDescriptiveRecipe irecipe = (IDescriptiveRecipe)recipe.asIRecipe();
            if (irecipe != null) {
                if (irecipe.getIngredients() != null) {
                    this.setIngredients(irecipe.getWidth(), irecipe.getHeight(), irecipe.getIngredients());
                }
                if (recipe.getBox() != null) {
                    this.inputs.add(new PositionedStack((Object)recipe.getBox(), 78, 6));
                }
                if (recipe.getLiquid() != null) {
                    this.tank = new PositionedFluidTank(recipe.getLiquid(), 10000, new Rectangle(145, 3, 16, 58), NEIHandlerCarpenter.this.getGuiTexture(), new Point(176, 0));
                }
                if (recipe.getCraftingResult() != null) {
                    this.output = new PositionedStack((Object)recipe.getCraftingResult(), 75, 37);
                }
            }
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedCarpenterRecipe(TileCarpenter.Recipe recipe) {
            this(recipe, false);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Object item = items[y * width + x];
                    if (item == null || item instanceof ItemStack[] && ((ItemStack[])item).length == 0 || item instanceof List && ((List)item).size() == 0) continue;
                    PositionedStack stack = new PositionedStack(item, 5 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerCarpenter.this.cycleticks / 20, this.inputs);
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

