/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.core.access.IOwnable;
import forestry.core.config.Constants;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.CoordTriplet;
import forestry.core.multiblock.IMultiblockPart;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.utils.Log;
import forestry.core.utils.PlayerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockTileEntityBase
extends IMultiblockPart
implements ISidedInventory,
IFilterSlotDelegate,
IOwnable {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;
    private boolean paused = false;
    private GameProfile owner;

    @Override
    public final Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public final void assertDetached() {
        if (this.controller != null) {
            Log.info("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", this.xCoord, this.yCoord, this.zCoord);
            this.controller = null;
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.hasKey("multiblockData")) {
            this.cachedMultiblockData = data.getCompoundTag("multiblockData");
        }
        if (data.hasKey("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)data.getCompoundTag("owner"));
        }
        this.getInternalInventory().readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            this.controller.writeToNBT(multiblockData);
            data.setTag("multiblockData", (NBTBase)multiblockData);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            data.setTag("owner", (NBTBase)nbt);
        }
        this.getInternalInventory().writeToNBT(data);
    }

    public boolean canUpdate() {
        return false;
    }

    public final void invalidate() {
        super.invalidate();
        this.detachSelf(false);
    }

    public final void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public final void validate() {
        super.validate();
        MultiblockRegistry.onPartAdded(this.worldObj, this);
    }

    public final Packet getDescriptionPacket() {
        NBTTagCompound packetData = new NBTTagCompound();
        this.encodeDescriptionPacket(packetData);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, packetData);
    }

    public final void onDataPacket(NetworkManager network, S35PacketUpdateTileEntity packet) {
        this.decodeDescriptionPacket(packet.func_148857_g());
    }

    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.setTag("multiblockData", (NBTBase)tag);
        }
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        if (packetData.hasKey("multiblockData")) {
            NBTTagCompound tag = packetData.getCompoundTag("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    public final boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public final NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public final void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public final boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public final MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public final CoordTriplet getWorldLocation() {
        return new CoordTriplet(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public final void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public final void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public final boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public final void setUnvisited() {
        this.visited = false;
    }

    @Override
    public final void setVisited() {
        this.visited = true;
    }

    @Override
    public final boolean isVisited() {
        return this.visited;
    }

    @Override
    public final void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public final void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public final IMultiblockPart[] getNeighboringParts() {
        CoordTriplet[] neighbors = new CoordTriplet[]{new CoordTriplet(this.xCoord - 1, this.yCoord, this.zCoord), new CoordTriplet(this.xCoord, this.yCoord - 1, this.zCoord), new CoordTriplet(this.xCoord, this.yCoord, this.zCoord - 1), new CoordTriplet(this.xCoord, this.yCoord, this.zCoord + 1), new CoordTriplet(this.xCoord, this.yCoord + 1, this.zCoord), new CoordTriplet(this.xCoord + 1, this.yCoord, this.zCoord)};
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        IChunkProvider chunkProvider = this.worldObj.getChunkProvider();
        for (CoordTriplet neighbor : neighbors) {
            TileEntity te;
            if (!chunkProvider.chunkExists(neighbor.getChunkX(), neighbor.getChunkZ()) || !((te = this.worldObj.getTileEntity(neighbor.x, neighbor.y, neighbor.z)) instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        IMultiblockPart[] tmp = new IMultiblockPart[neighborParts.size()];
        return neighborParts.toArray(tmp);
    }

    @Override
    public final void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.markDirty();
        this.worldObj.markTileEntityChunkModified(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
    }

    public void notifyNeighborsOfBlockChange() {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
    }

    protected void notifyNeighborsOfTileChange() {
        this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.worldObj, this);
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return PlayerUtil.isSameGameProfile(this.owner, player.getGameProfile());
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public boolean allowsAutomation() {
        return false;
    }

    public final int getSizeInventory() {
        return this.getInternalInventory().getSizeInventory();
    }

    public final ItemStack getStackInSlot(int slotIndex) {
        return this.getInternalInventory().getStackInSlot(slotIndex);
    }

    public final ItemStack decrStackSize(int slotIndex, int amount) {
        return this.getInternalInventory().decrStackSize(slotIndex, amount);
    }

    public final ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.getInternalInventory().getStackInSlotOnClosing(slotIndex);
    }

    public final void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().setInventorySlotContents(slotIndex, itemstack);
    }

    public final int getInventoryStackLimit() {
        return this.getInternalInventory().getInventoryStackLimit();
    }

    public final void openInventory() {
        this.getInternalInventory().openInventory();
    }

    public final void closeInventory() {
        this.getInternalInventory().closeInventory();
    }

    public final String getInventoryName() {
        return this.getInternalInventory().getInventoryName();
    }

    public final boolean isUseableByPlayer(EntityPlayer player) {
        return this.getInternalInventory().isUseableByPlayer(player);
    }

    public final boolean hasCustomInventoryName() {
        return this.getInternalInventory().hasCustomInventoryName();
    }

    public final boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().isItemValidForSlot(slotIndex, itemStack);
    }

    public final int[] getAccessibleSlotsFromSide(int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().getAccessibleSlotsFromSide(side);
        }
        return Constants.SLOTS_NONE;
    }

    public final boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().canInsertItem(slotIndex, itemStack, side);
        }
        return false;
    }

    public final boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().canExtractItem(slotIndex, itemStack, side);
        }
        return false;
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public final boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public void openGui(EntityPlayer player) {
    }
}

