/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.PostManager;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiTextBox;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.StringUtil;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.items.ItemLetter;
import forestry.mail.network.PacketLetterInfoRequest;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiLetter
extends GuiForestry<ContainerLetter, ItemLetter.LetterInventory> {
    private final boolean isProcessedLetter;
    private boolean checkedSessionVars;
    private GuiTextField address;
    private GuiTextBox text;
    private boolean addressFocus;
    private boolean textFocus;
    private final ArrayList<Widget> tradeInfoWidgets;

    public GuiLetter(EntityPlayer player, ItemLetter.LetterInventory inventory) {
        super("textures/gui/letter.png", new ContainerLetter(player, inventory), inventory);
        this.xSize = 194;
        this.ySize = 227;
        this.isProcessedLetter = ((ContainerLetter)this.container).getLetter().isProcessed();
        this.widgetManager.add(new AddresseeSlot(16, 12));
        this.tradeInfoWidgets = new ArrayList();
    }

    public void initGui() {
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        this.address = new GuiTextField(this.fontRendererObj, this.guiLeft + 46, this.guiTop + 13, 93, 13);
        IMailAddress recipient = ((ContainerLetter)this.container).getRecipient();
        if (recipient != null) {
            this.address.setText(recipient.getName());
        }
        this.text = new GuiTextBox(this.fontRendererObj, this.guiLeft + 17, this.guiTop + 31, 122, 57);
        this.text.setMaxStringLength(128);
        if (!((ContainerLetter)this.container).getText().isEmpty()) {
            this.text.setText(((ContainerLetter)this.container).getText());
        }
    }

    protected void keyTyped(char eventCharacter, int eventKey) {
        if (this.address.isFocused()) {
            if (eventKey == 28) {
                this.address.setFocused(false);
            } else {
                this.address.textboxKeyTyped(eventCharacter, eventKey);
            }
            return;
        }
        if (this.text.isFocused()) {
            if (eventKey == 28) {
                if (Proxies.common.isShiftDown()) {
                    this.text.setText(this.text.getText() + "\n");
                } else {
                    this.text.setFocused(false);
                }
            } else if (eventKey == 208) {
                this.text.advanceLine();
            } else if (eventKey == 200) {
                this.text.regressLine();
            } else if (this.text.moreLinesAllowed() || eventKey == 211 || eventKey == 14) {
                this.text.textboxKeyTyped(eventCharacter, eventKey);
            }
            return;
        }
        super.keyTyped(eventCharacter, eventKey);
    }

    @Override
    protected void mouseClicked(int par1, int par2, int mouseButton) {
        super.mouseClicked(par1, par2, mouseButton);
        this.address.mouseClicked(par1, par2, mouseButton);
        this.text.mouseClicked(par1, par2, mouseButton);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        EnumAddressee recipientType;
        String recipient;
        if (!this.isProcessedLetter && !this.checkedSessionVars) {
            this.checkedSessionVars = true;
            this.setFromSessionVars();
            recipient = this.address.getText();
            recipientType = ((ContainerLetter)this.container).getCarrierType();
            this.setRecipient(recipient, recipientType);
        }
        if (this.addressFocus != this.address.isFocused() && StringUtils.isNotBlank((CharSequence)(recipient = this.address.getText()))) {
            recipientType = ((ContainerLetter)this.container).getCarrierType();
            this.setRecipient(recipient, recipientType);
        }
        this.addressFocus = this.address.isFocused();
        if (this.textFocus != this.text.isFocused()) {
            this.setText();
        }
        this.textFocus = this.text.isFocused();
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        if (this.isProcessedLetter) {
            this.fontRendererObj.drawString(this.address.getText(), this.guiLeft + 49, this.guiTop + 16, this.fontColor.get("gui.mail.lettertext"));
            this.fontRendererObj.drawSplitString(this.text.getText(), this.guiLeft + 20, this.guiTop + 34, 119, this.fontColor.get("gui.mail.lettertext"));
        } else {
            this.clearTradeInfoWidgets();
            this.address.drawTextBox();
            if (((ContainerLetter)this.container).getCarrierType() == EnumAddressee.TRADER) {
                this.drawTradePreview(18, 32);
            } else {
                this.text.drawTextBox();
            }
        }
    }

    private void drawTradePreview(int x, int y) {
        String infoString = null;
        if (((ContainerLetter)this.container).getTradeInfo() == null) {
            infoString = "gui.mail.notrader";
        } else if (((ContainerLetter)this.container).getTradeInfo().tradegood == null) {
            infoString = "gui.mail.nothingtotrade";
        } else if (!((ContainerLetter)this.container).getTradeInfo().state.isOk()) {
            infoString = "chat.mail." + ((ContainerLetter)this.container).getTradeInfo().state.getIdentifier();
        }
        if (infoString != null) {
            this.fontRendererObj.drawSplitString(StringUtil.localize(infoString), this.guiLeft + x, this.guiTop + y, 119, this.fontColor.get("gui.mail.lettertext"));
            return;
        }
        this.fontRendererObj.drawString(StringUtil.localize("gui.mail.pleasesend"), this.guiLeft + x, this.guiTop + y, this.fontColor.get("gui.mail.lettertext"));
        this.addTradeInfoWidget(new GuiForestry.ItemStackWidget(x, y + 10, ((ContainerLetter)this.container).getTradeInfo().tradegood));
        GL11.glDisable((int)2896);
        this.fontRendererObj.drawString(StringUtil.localize("gui.mail.foreveryattached"), this.guiLeft + x, this.guiTop + y + 28, this.fontColor.get("gui.mail.lettertext"));
        GL11.glEnable((int)2896);
        for (int i = 0; i < ((ContainerLetter)this.container).getTradeInfo().required.length; ++i) {
            this.addTradeInfoWidget(new GuiForestry.ItemStackWidget(x + i * 18, y + 38, ((ContainerLetter)this.container).getTradeInfo().required[i]));
        }
    }

    private void addTradeInfoWidget(Widget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    public void onGuiClosed() {
        String recipientName = this.address.getText();
        EnumAddressee recipientType = ((ContainerLetter)this.container).getCarrierType();
        this.setRecipient(recipientName, recipientType);
        this.setText();
        Keyboard.enableRepeatEvents((boolean)false);
        super.onGuiClosed();
    }

    protected boolean checkHotbarKeys(int key) {
        return false;
    }

    private void setFromSessionVars() {
        if (SessionVars.getStringVar("mail.letter.recipient") == null) {
            return;
        }
        String recipient = SessionVars.getStringVar("mail.letter.recipient");
        String typeName = SessionVars.getStringVar("mail.letter.addressee");
        if (StringUtils.isNotBlank((CharSequence)recipient) && StringUtils.isNotBlank((CharSequence)typeName)) {
            this.address.setText(recipient);
            EnumAddressee type = EnumAddressee.fromString(typeName);
            ((ContainerLetter)this.container).setCarrierType(type);
        }
        SessionVars.clearStringVar("mail.letter.recipient");
        SessionVars.clearStringVar("mail.letter.addressee");
    }

    private void setRecipient(String recipientName, EnumAddressee type) {
        if (this.isProcessedLetter || StringUtils.isBlank((CharSequence)recipientName) || type == null) {
            return;
        }
        PacketLetterInfoRequest packet = new PacketLetterInfoRequest(recipientName, type);
        Proxies.net.sendToServer(packet);
    }

    private void setText() {
        if (this.isProcessedLetter) {
            return;
        }
        ((ContainerLetter)this.container).setText(this.text.getText());
    }

    protected class AddresseeSlot
    extends Widget {
        public AddresseeSlot(int xPos, int yPos) {
            super(GuiLetter.this.widgetManager, xPos, yPos);
            this.width = 26;
            this.height = 15;
        }

        @Override
        public void draw(int startX, int startY) {
            IPostalCarrier carrier = PostManager.postRegistry.getCarrier(((ContainerLetter)GuiLetter.this.container).getCarrierType());
            if (carrier != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Proxies.common.bindTexture(SpriteSheet.ITEMS);
                GuiLetter.this.drawTexturedModelRectFromIcon(startX + this.xPos, startY + this.yPos - 5, carrier.getIcon(), 26, 26);
            }
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            return StringUtil.localize("gui.addressee." + ((ContainerLetter)GuiLetter.this.container).getCarrierType().toString());
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            if (!GuiLetter.this.isProcessedLetter) {
                ((ContainerLetter)GuiLetter.this.container).advanceCarrierType();
            }
        }
    }
}

