/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.api.arboriculture.EnumLeafType;
import forestry.core.render.TextureManager;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public class TextureLeaves {
    private static final Map<EnumLeafType, TextureLeaves> leafTextures = new EnumMap<EnumLeafType, TextureLeaves>(EnumLeafType.class);
    private final EnumLeafType leafType;
    private IIcon plain;
    private IIcon pollinated;
    private IIcon fancy;

    public static TextureLeaves get(EnumLeafType leafType) {
        return leafTextures.get((Object)leafType);
    }

    public static void registerAllIcons(IIconRegister register) {
        for (TextureLeaves leafTexture : leafTextures.values()) {
            leafTexture.registerIcons(register);
        }
    }

    private TextureLeaves(EnumLeafType enumLeafType) {
        this.leafType = enumLeafType;
    }

    private void registerIcons(IIconRegister register) {
        TextureManager textureManager = TextureManager.getInstance();
        String ident = this.leafType.toString().toLowerCase(Locale.ENGLISH);
        this.plain = textureManager.registerTex(register, "leaves/" + ident + ".plain");
        this.pollinated = textureManager.registerTex(register, "leaves/" + ident + ".changed");
        this.fancy = textureManager.registerTex(register, "leaves/" + ident + ".fancy");
    }

    public IIcon getPlain() {
        return this.plain;
    }

    public IIcon getPollinated() {
        return this.pollinated;
    }

    public IIcon getFancy() {
        return this.fancy;
    }

    static {
        for (EnumLeafType leafType : EnumLeafType.values()) {
            leafTextures.put(leafType, new TextureLeaves(leafType));
        }
    }
}

