/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.apiculture.items.ItemImprinter;
import forestry.apiculture.network.PacketImprintSelectionRequest;
import forestry.apiculture.network.PacketImprintSelectionResponse;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.network.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerImprinter
extends ContainerItemInventory<ItemImprinter.ImprinterInventory>
implements IGuiSelectable {
    private boolean isNetSynced = false;

    public ContainerImprinter(InventoryPlayer inventoryplayer, ItemImprinter.ImprinterInventory inventory) {
        super(inventory, inventoryplayer, 8, 103);
        this.addSlotToContainer(new SlotFiltered(inventory, 0, 152, 12));
        this.addSlotToContainer(new SlotOutput(inventory, 1, 152, 72));
    }

    public void onContainerClosed(EntityPlayer entityplayer) {
        if (entityplayer.worldObj.isRemote) {
            return;
        }
        for (int i = 0; i < ((ItemImprinter.ImprinterInventory)this.inventory).getSizeInventory(); ++i) {
            ItemStack stack = ((ItemImprinter.ImprinterInventory)this.inventory).getStackInSlot(i);
            if (stack == null) continue;
            Proxies.common.dropItemPlayer(entityplayer, stack);
            ((ItemImprinter.ImprinterInventory)this.inventory).setInventorySlotContents(i, null);
        }
    }

    public void advanceSelection(int index) {
        this.sendSelectionChange(index, 0);
    }

    public void regressSelection(int index) {
        this.sendSelectionChange(index, 1);
    }

    public void updateContainer(World world) {
        if (!this.isNetSynced && world.isRemote) {
            this.isNetSynced = true;
            Proxies.net.sendToServer(new PacketImprintSelectionRequest());
        }
    }

    private void sendSelectionChange(int index, int advance) {
        PacketGuiSelectRequest packet = new PacketGuiSelectRequest(index, advance);
        Proxies.net.sendToServer(packet);
        this.isNetSynced = false;
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packetRequest) {
        if (packetRequest.getSecondaryIndex() == 0) {
            if (packetRequest.getPrimaryIndex() == 0) {
                ((ItemImprinter.ImprinterInventory)this.inventory).advancePrimary();
            } else {
                ((ItemImprinter.ImprinterInventory)this.inventory).advanceSecondary();
            }
        } else if (packetRequest.getPrimaryIndex() == 0) {
            ((ItemImprinter.ImprinterInventory)this.inventory).regressPrimary();
        } else {
            ((ItemImprinter.ImprinterInventory)this.inventory).regressSecondary();
        }
        this.sendSelection(player);
    }

    public void sendSelection(EntityPlayerMP player) {
        PacketImprintSelectionResponse packetResponse = new PacketImprintSelectionResponse(((ItemImprinter.ImprinterInventory)this.inventory).getPrimaryIndex(), ((ItemImprinter.ImprinterInventory)this.inventory).getSecondaryIndex());
        Proxies.net.sendToPlayer(packetResponse, (EntityPlayer)player);
    }

    public void setSelection(PacketImprintSelectionResponse packetPayload) {
        ((ItemImprinter.ImprinterInventory)this.inventory).setPrimaryIndex(packetPayload.getPrimaryIndex());
        ((ItemImprinter.ImprinterInventory)this.inventory).setSecondaryIndex(packetPayload.getSecondaryIndex());
    }
}

