/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.world.World;

public abstract class WorldGenTree
extends WorldGenArboriculture {
    private static final int minHeight = 4;
    private static final int maxHeight = 80;
    private final int baseHeight;
    private final int heightVariation;
    protected int girth;
    protected int height;

    protected WorldGenTree(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree);
        this.baseHeight = baseHeight;
        this.heightVariation = heightVariation;
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
    }

    protected WorldGenBase.Vector getCenteredAt(int yCenter, int xOffset, int zOffset) {
        float cent = this.girth % 2 == 0 ? 0.5f : 0.0f;
        return new WorldGenBase.Vector(cent + (float)xOffset, yCenter, cent + (float)zOffset);
    }

    protected void generateAdjustedCylinder(World world, int yCenter, float radius, int height, ITreeBlockType block) {
        this.generateAdjustedCylinder(world, yCenter, 0, 0, radius, height, block, WorldGenBase.EnumReplaceMode.SOFT);
    }

    protected void generateAdjustedCylinder(World world, int yCenter, float radius, int height, ITreeBlockType block, WorldGenBase.EnumReplaceMode replace) {
        this.generateAdjustedCylinder(world, yCenter, 0, 0, radius, height, block, replace);
    }

    protected void generateAdjustedCylinder(World world, int yCenter, int xOffset, int zOffset, float radius, int height, ITreeBlockType block, WorldGenBase.EnumReplaceMode replace) {
        WorldGenBase.Vector center = this.getCenteredAt(yCenter, xOffset, zOffset);
        this.generateCylinder(world, center, radius + (float)this.girth, height, block, replace);
    }

    protected void generateAdjustedCircle(World world, int yCenter, int xOffset, int zOffset, float radius, int width, int height, ITreeBlockType block, float chance, WorldGenBase.EnumReplaceMode replace) {
        WorldGenBase.Vector center = this.getCenteredAt(yCenter, xOffset, zOffset);
        this.generateCircle(world, center, radius, width, height, block, chance, replace);
    }

    @Override
    public boolean canGrow(World world, int x, int y, int z) {
        return this.tree.canGrow(world, x, y, z, this.girth, this.height);
    }

    @Override
    public final void preGenerate(World world, int startX, int startY, int startZ) {
        super.preGenerate(world, startX, startY, startZ);
        this.height = this.determineHeight(world, this.baseHeight, this.heightVariation);
        this.girth = this.tree.getGirth(world, startX, startY, startZ);
    }

    protected int modifyByHeight(World world, int val, int min, int max) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int determined = Math.round((float)val * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return determined < min ? min : (determined > max ? max : determined);
    }

    private int determineHeight(World world, int required, int variation) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int baseHeight = required + world.rand.nextInt(variation);
        int height = Math.round((float)baseHeight * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return height < 4 ? 4 : (height > 80 ? 80 : height);
    }

    @Override
    public TreeBlockTypeLeaf getLeaf(GameProfile owner) {
        return new TreeBlockTypeLeaf(owner);
    }

    @Override
    public ITreeBlockType getWood() {
        return new TreeBlockTypeLog();
    }
}

