/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.config.ForestryItem;
import forestry.core.items.ItemForestryFood;
import forestry.core.render.TextureManager;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFruit
extends ItemForestryFood {
    public ItemFruit() {
        super(1, 0.2f);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.registerOreDictionary();
    }

    private void registerOreDictionary() {
        for (EnumFruit def : EnumFruit.values()) {
            OreDictionary.registerOre((String)def.oreDict, (ItemStack)new ItemStack((Item)this, 1, def.ordinal()));
        }
    }

    public boolean isDamageable() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        EnumFruit.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return EnumFruit.values()[meta].getIcon();
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < EnumFruit.values().length; ++i) {
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (stack.getItemDamage() < 0 || stack.getItemDamage() >= EnumFruit.VALUES.length) {
            return null;
        }
        return super.getUnlocalizedName(stack) + "." + EnumFruit.VALUES[stack.getItemDamage()].name().toLowerCase(Locale.ENGLISH);
    }

    public static enum EnumFruit {
        CHERRY("cropCherry"),
        WALNUT("cropWalnut"),
        CHESTNUT("cropChestnut"),
        LEMON("cropLemon"),
        PLUM("cropPlum"),
        DATES("cropDate"),
        PAPAYA("cropPapaya");

        public static final EnumFruit[] VALUES;
        final String oreDict;
        private static IIcon[] icons;

        private EnumFruit(String oreDict) {
            this.oreDict = oreDict;
        }

        public static void registerIcons(IIconRegister register) {
            icons = new IIcon[VALUES.length];
            for (int i = 0; i < VALUES.length; ++i) {
                EnumFruit.icons[i] = TextureManager.getInstance().registerTex(register, "fruits/" + VALUES[i].toString().toLowerCase(Locale.ENGLISH));
            }
        }

        public IIcon getIcon() {
            return icons[this.ordinal()];
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int qty) {
            return ForestryItem.fruits.getItemStack(qty, this.ordinal());
        }

        static {
            VALUES = EnumFruit.values();
        }
    }
}

