/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.apiculture.BeeHousingListener;
import forestry.apiculture.BeeHousingModifier;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.genetics.ApiaristTracker;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeGenome;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.SpeciesRoot;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class BeeHelper
extends SpeciesRoot
implements IBeeRoot {
    private static int beeSpeciesCount = -1;
    public static final String UID = "rootBees";
    private static final ArrayList<IBee> beeTemplates = new ArrayList();
    private static final ArrayList<IBeeMutation> beeMutations = new ArrayList();
    private final ArrayList<IBeekeepingMode> beekeepingModes = new ArrayList();
    private static IBeekeepingMode activeBeekeepingMode;

    @Override
    public String getUID() {
        return UID;
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return IBee.class;
    }

    @Override
    public int getSpeciesCount() {
        if (beeSpeciesCount < 0) {
            beeSpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleBeeSpecies) || !((IAlleleBeeSpecies)entry.getValue()).isCounted()) continue;
                ++beeSpeciesCount;
            }
        }
        return beeSpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack stack) {
        return this.getType(stack) != EnumBeeType.NONE;
    }

    @Override
    public boolean isMember(ItemStack stack, int type) {
        return this.getType(stack).ordinal() == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IBee;
    }

    @Override
    public ItemStack getMemberStack(IIndividual bee, int type) {
        Item beeItem;
        if (!this.isMember(bee)) {
            return null;
        }
        switch (EnumBeeType.VALUES[type]) {
            case QUEEN: {
                beeItem = ForestryItem.beeQueenGE.item();
                break;
            }
            case PRINCESS: {
                beeItem = ForestryItem.beePrincessGE.item();
                break;
            }
            case DRONE: {
                beeItem = ForestryItem.beeDroneGE.item();
                break;
            }
            case LARVAE: {
                beeItem = ForestryItem.beeLarvaeGE.item();
                break;
            }
            default: {
                throw new RuntimeException("Cannot instantiate a bee of type " + type);
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        bee.writeToNBT(nbttagcompound);
        ItemStack beeStack = new ItemStack(beeItem);
        beeStack.setTagCompound(nbttagcompound);
        return beeStack;
    }

    @Override
    public EnumBeeType getType(ItemStack stack) {
        if (stack == null) {
            return EnumBeeType.NONE;
        }
        if (ForestryItem.beeDroneGE.isItemEqual(stack)) {
            return EnumBeeType.DRONE;
        }
        if (ForestryItem.beePrincessGE.isItemEqual(stack)) {
            return EnumBeeType.PRINCESS;
        }
        if (ForestryItem.beeQueenGE.isItemEqual(stack)) {
            return EnumBeeType.QUEEN;
        }
        if (ForestryItem.beeLarvaeGE.isItemEqual(stack)) {
            return EnumBeeType.LARVAE;
        }
        return EnumBeeType.NONE;
    }

    @Override
    public boolean isDrone(ItemStack stack) {
        return this.getType(stack) == EnumBeeType.DRONE;
    }

    @Override
    public boolean isMated(ItemStack stack) {
        if (this.getType(stack) != EnumBeeType.QUEEN) {
            return false;
        }
        NBTTagCompound nbt = stack.getTagCompound();
        return nbt != null && nbt.hasKey("Mate");
    }

    @Override
    public IBee getMember(ItemStack stack) {
        if (!this.isMember(stack)) {
            return null;
        }
        return new Bee(stack.getTagCompound());
    }

    @Override
    public IBee getMember(NBTTagCompound compound) {
        return new Bee(compound);
    }

    @Override
    public IBee getBee(World world, IBeeGenome genome) {
        return new Bee(genome);
    }

    @Override
    public IBee getBee(World world, IBeeGenome genome, IBee mate) {
        return new Bee(genome, mate);
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] template) {
        return new BeeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new BeeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public IBee templateAsIndividual(IAllele[] template) {
        return new Bee(this.templateAsGenome(template));
    }

    @Override
    public IBee templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Bee(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public ArrayList<IBee> getIndividualTemplates() {
        return beeTemplates;
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        beeTemplates.add(new Bee(BeeManager.beeRoot.templateAsGenome(template)));
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return BeeDefinition.FOREST.getTemplate();
    }

    @Override
    public Collection<IBeeMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(beeMutations);
        }
        return beeMutations;
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        beeMutations.add((IBeeMutation)mutation);
    }

    @Override
    public void resetBeekeepingMode() {
        activeBeekeepingMode = null;
    }

    @Override
    public ArrayList<IBeekeepingMode> getBeekeepingModes() {
        return this.beekeepingModes;
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(World world) {
        if (activeBeekeepingMode != null) {
            return activeBeekeepingMode;
        }
        IApiaristTracker tracker = this.getBreedingTracker(world, null);
        String mode = tracker.getModeName();
        if (mode == null || mode.isEmpty()) {
            mode = PluginApiculture.beekeepingMode;
        }
        this.setBeekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().debug("Set beekeeping mode for a world to " + mode);
        return activeBeekeepingMode;
    }

    @Override
    public void registerBeekeepingMode(IBeekeepingMode mode) {
        this.beekeepingModes.add(mode);
    }

    @Override
    public void setBeekeepingMode(World world, String name) {
        activeBeekeepingMode = this.getBeekeepingMode(name);
        this.getBreedingTracker(world, null).setModeName(name);
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(String name) {
        for (IBeekeepingMode mode : this.beekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().debug("Failed to find a beekeeping mode called '%s', reverting to fallback.");
        return this.beekeepingModes.get(0);
    }

    @Override
    public IApiaristTracker getBreedingTracker(World world, GameProfile player) {
        String filename = "ApiaristTracker." + (player == null ? "common" : player.getId());
        ApiaristTracker tracker = (ApiaristTracker)world.loadItemData(ApiaristTracker.class, filename);
        if (tracker == null) {
            tracker = new ApiaristTracker(filename, player);
            world.setItemData(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    @Override
    public IBeekeepingLogic createBeekeepingLogic(IBeeHousing housing) {
        return new BeekeepingLogic(housing);
    }

    @Override
    public IBeeModifier createBeeHousingModifier(IBeeHousing housing) {
        return new BeeHousingModifier(housing);
    }

    @Override
    public IBeeListener createBeeHousingListener(IBeeHousing housing) {
        return new BeeHousingListener(housing);
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumBeeChromosome.values();
    }

    @Override
    public IChromosomeType getKaryotypeKey() {
        return EnumBeeChromosome.SPECIES;
    }
}

