/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public abstract class GuiAlyzer
extends GuiForestry<ContainerAlyzer, IInventory> {
    protected static final int COLUMN_0 = 12;
    protected static final int COLUMN_1 = 90;
    protected static final int COLUMN_2 = 155;
    private final ISpeciesRoot speciesRoot;
    private final IBreedingTracker breedingTracker;
    private final String guiName;
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    protected GuiAlyzer(String speciesRoot, EntityPlayer player, ContainerAlyzer container, IInventory inventory, String guiName) {
        super("textures/gui/beealyzer2.png", container, inventory);
        this.xSize = 246;
        this.ySize = 238;
        this.guiName = guiName;
        this.speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(speciesRoot);
        this.breedingTracker = this.speciesRoot.getBreedingTracker(player.worldObj, player.getGameProfile());
    }

    protected final int getColorCoding(boolean dominant) {
        if (dominant) {
            return this.fontColor.get("gui.beealyzer.dominant");
        }
        return this.fontColor.get("gui.beealyzer.recessive");
    }

    protected final void drawLine(String text, int x, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, IIndividual individual, IChromosomeType chromosome, boolean inactive) {
        if (!inactive) {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()));
        } else {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
        }
    }

    protected final void drawRow(String text0, String text1, String text2, IIndividual individual, IChromosomeType chromosome) {
        this.drawRow(text0, text1, text2, this.fontColor.get("gui.screen"), this.getColorCoding(individual.getGenome().getActiveAllele(chromosome).isDominant()), this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome).isDominant()));
    }

    protected final void drawChromosomeRow(String chromosomeName, IIndividual individual, IChromosomeType chromosome) {
        IAllele active = individual.getGenome().getActiveAllele(chromosome);
        IAllele inactive = individual.getGenome().getInactiveAllele(chromosome);
        this.drawRow(chromosomeName, active.getName(), inactive.getName(), this.fontColor.get("gui.screen"), this.getColorCoding(active.isDominant()), this.getColorCoding(inactive.isDominant()));
    }

    protected final void drawSpeciesRow(String text0, IIndividual individual, IChromosomeType chromosome, String customPrimaryName, String customSecondaryName) {
        IAlleleSpecies primary = individual.getGenome().getPrimary();
        IAlleleSpecies secondary = individual.getGenome().getSecondary();
        this.drawLine(text0, this.column0);
        int columnwidth = this.column2 - this.column1 - 2;
        RenderHelper.enableStandardItemLighting();
        this.drawItemStack(this.iconStacks.get(primary.getUID()), this.guiLeft + this.column1 + (columnwidth - 20), this.guiTop + 10);
        this.drawItemStack(this.iconStacks.get(secondary.getUID()), this.guiLeft + this.column2 + (columnwidth - 20), this.guiTop + 10);
        RenderHelper.disableStandardItemLighting();
        String primaryName = customPrimaryName == null ? primary.getName() : customPrimaryName;
        String secondaryName = customSecondaryName == null ? secondary.getName() : customSecondaryName;
        this.drawSplitLine(primaryName, this.column1, columnwidth, individual, chromosome, false);
        this.drawSplitLine(secondaryName, this.column2, columnwidth, individual, chromosome, true);
        this.newLine();
    }

    protected static String checkCustomName(String key) {
        if (StringUtil.canTranslate(key)) {
            return StringUtil.localize(key);
        }
        return null;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        this.widgetManager.clear();
    }

    protected void drawAnalyticsOverview() {
        this.startPage();
        this.newLine();
        String title = StringUtil.localize(this.guiName).toUpperCase();
        this.drawCenteredLine(title, 8, 208);
        this.newLine();
        this.fontRendererObj.drawSplitString(StringUtil.localize(this.guiName + ".help"), this.guiLeft + 12 + 4, this.guiTop + 42, 200, this.fontColor.get("gui.screen"));
        this.newLine();
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.alyzer.overview") + ":", 16);
        this.newLine();
        this.drawLine("I  : " + StringUtil.localize("gui.general"), 16);
        this.newLine();
        this.drawLine("II : " + StringUtil.localize("gui.environment"), 16);
        this.newLine();
        this.drawLine("III: " + StringUtil.localize("gui.produce"), 16);
        this.newLine();
        this.drawLine("IV : " + StringUtil.localize("gui.evolution"), 16);
        this.newLine();
        String mode = this.breedingTracker.getModeName();
        if (mode != null && !mode.isEmpty()) {
            String rules = StringUtil.localize(this.guiName + ".behaviour") + ": " + WordUtils.capitalize((String)mode);
            this.drawCenteredLine(rules, 8, 208, this.fontColor.get(this.guiName + ".binomial"));
        }
        this.endPage();
    }

    protected final void drawAnalyticsPageClassification(IIndividual individual) {
        this.startPage();
        this.drawLine(StringUtil.localize("gui.alyzer.classification") + ":", 12);
        this.newLine();
        Stack<IClassification> hierarchy = new Stack<IClassification>();
        for (IClassification classification = individual.getGenome().getPrimary().getBranch(); classification != null; classification = classification.getParent()) {
            if (classification.getScientific() == null || classification.getScientific().isEmpty()) continue;
            hierarchy.push(classification);
        }
        boolean overcrowded = hierarchy.size() > 5;
        int x = 12;
        IClassification group = null;
        while (!hierarchy.isEmpty()) {
            group = (IClassification)hierarchy.pop();
            if (overcrowded && group.getLevel().isDroppable()) continue;
            this.drawLine(group.getScientific(), x, group.getLevel().getColour());
            this.drawLine(group.getLevel().name(), 170, group.getLevel().getColour());
            this.newLineCompressed();
            x += 12;
        }
        String binomial = individual.getGenome().getPrimary().getBinomial();
        if (group != null && group.getLevel() == IClassification.EnumClassLevel.GENUS) {
            binomial = group.getScientific().substring(0, 1) + ". " + binomial.toLowerCase(Locale.ENGLISH);
        }
        this.drawLine(binomial, x, 15445637);
        this.drawLine("SPECIES", 170, 15445637);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.alyzer.authority") + ": " + individual.getGenome().getPrimary().getAuthority(), 12);
        if (AlleleManager.alleleRegistry.isBlacklisted(individual.getIdent())) {
            String extinct = ">> " + StringUtil.localize("gui.alyzer.extinct").toUpperCase() + " <<";
            this.fontRendererObj.drawStringWithShadow(extinct, this.guiLeft + 200 - this.fontRendererObj.getStringWidth(extinct), this.guiTop + this.getLineY(), this.fontColor.get("gui.beealyzer.dominant"));
        }
        this.newLine();
        String description = individual.getGenome().getPrimary().getDescription();
        if (StringUtils.isBlank((CharSequence)description) || description.startsWith("for.description.")) {
            this.drawSplitLine(StringUtil.localize("gui.alyzer.nodescription"), 12, 200, 0x666666);
        } else {
            String[] tokens = description.split("\\|");
            this.drawSplitLine(tokens[0], 12, 200, 0x666666);
            if (tokens.length > 1) {
                String signature = "- " + tokens[1];
                this.fontRendererObj.drawStringWithShadow(signature, this.guiLeft + 210 - this.fontRendererObj.getStringWidth(signature), this.guiTop + 145 - 14, 10079282);
            }
        }
        this.endPage();
    }

    protected void drawAnalyticsPageMutations(IIndividual individual) {
        this.startPage(12, 90, 155);
        this.drawLine(StringUtil.localize("gui.beealyzer.mutations") + ":", 12);
        this.newLine();
        RenderHelper.enableGUIStandardItemLighting();
        HashMap<IMutation, IAlleleSpecies> combinations = new HashMap<IMutation, IAlleleSpecies>();
        for (IMutation iMutation : this.speciesRoot.getCombinations(individual.getGenome().getPrimary())) {
            combinations.put(iMutation, individual.getGenome().getPrimary());
        }
        for (IMutation iMutation : this.speciesRoot.getCombinations(individual.getGenome().getSecondary())) {
            combinations.put(iMutation, individual.getGenome().getSecondary());
        }
        int columnWidth = 50;
        boolean bl = false;
        for (Map.Entry mutation : combinations.entrySet()) {
            boolean bl2;
            if (this.breedingTracker.isDiscovered((IMutation)mutation.getKey())) {
                this.drawMutationInfo((IMutation)mutation.getKey(), (IAllele)mutation.getValue(), 12 + bl2);
            } else {
                if (((IMutation)mutation.getKey()).isSecret()) continue;
                this.drawUnknownMutation((IMutation)mutation.getKey(), 12 + bl2);
            }
            if ((bl2 += columnWidth) < columnWidth * 4) continue;
            bl2 = false;
            this.newLine();
        }
        this.endPage();
    }

    protected void drawMutationInfo(IMutation combination, IAllele species, int x) {
        ItemStack partnerBee = this.iconStacks.get(combination.getPartner(species).getUID());
        this.widgetManager.add(new GuiForestry.ItemStackWidget(x, this.getLineY(), partnerBee));
        this.drawProbabilityArrow(combination.getBaseChance(), this.guiLeft + x + 18, this.guiTop + this.getLineY() + 4);
        IAllele result = combination.getTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        ItemStack resultBee = this.iconStacks.get(result.getUID());
        this.widgetManager.add(new GuiForestry.ItemStackWidget(x + 33, this.getLineY(), resultBee));
    }

    private void drawUnknownMutation(IMutation combination, int x) {
        this.drawQuestionMark(this.guiLeft + x, this.guiTop + this.getLineY());
        this.drawProbabilityArrow(combination.getBaseChance(), this.guiLeft + x + 18, this.guiTop + this.getLineY() + 4);
        this.drawQuestionMark(this.guiLeft + x + 32, this.guiTop + this.getLineY());
    }

    private void drawQuestionMark(int x, int y) {
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(x, y, 78, 240, 16, 16);
    }

    private void drawProbabilityArrow(float chance, int x, int y) {
        int line = 247;
        int column = 100;
        switch (EnumMutateChance.rateChance(chance)) {
            case HIGHEST: {
                column = 100;
                break;
            }
            case HIGHER: {
                column = 115;
                break;
            }
            case HIGH: {
                column = 130;
                break;
            }
            case NORMAL: {
                column = 145;
                break;
            }
            case LOW: {
                column = 160;
                break;
            }
            case LOWEST: {
                column = 175;
            }
        }
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(x, y, column, line, 15, 9);
    }

    protected void drawToleranceInfo(IAlleleTolerance toleranceAllele, int x) {
        int textColor = this.getColorCoding(toleranceAllele.isDominant());
        EnumTolerance tolerance = toleranceAllele.getValue();
        String text = "(" + toleranceAllele.getName() + ")";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(x - 2, this.getLineY() - 1);
                this.drawLine(text, x + 14, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(x - 2, this.getLineY() - 1);
                this.drawLine(text, x + 14, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(x - 2, this.getLineY() - 1);
                this.drawLine(text, x + 14, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(x - 2, this.getLineY() - 1);
                this.drawLine("(0)", x + 14, textColor);
            }
        }
    }

    private void drawDownSymbol(int x, int y) {
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(this.guiLeft + x, this.guiTop + y, 0, 247, 15, 9);
    }

    private void drawUpSymbol(int x, int y) {
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(this.guiLeft + x, this.guiTop + y, 15, 247, 15, 9);
    }

    private void drawBothSymbol(int x, int y) {
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(this.guiLeft + x, this.guiTop + y, 30, 247, 15, 9);
    }

    private void drawNoneSymbol(int x, int y) {
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(this.guiLeft + x, this.guiTop + y, 45, 247, 15, 9);
    }

    protected void drawFertilityInfo(int fertility, int x, int textColor, int texOffset) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String fertilityString = Integer.toString(fertility) + " x";
        int stringWidth = this.fontRendererObj.getStringWidth(fertilityString);
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(this.guiLeft + x + stringWidth + 2, this.guiTop + this.getLineY() - 1, 60, 240 + texOffset, 12, 8);
        this.drawLine(fertilityString, x, textColor);
    }
}

