/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public final class Hive {
    private final IHiveDescription hiveDescription;
    private final List<IHiveDrop> drops = new ArrayList<IHiveDrop>();

    public Hive(IHiveDescription hiveDescription) {
        if (hiveDescription == null) {
            throw new IllegalArgumentException("Tried to create hive with null hive description");
        }
        this.hiveDescription = hiveDescription;
    }

    public Block getHiveBlock() {
        return this.hiveDescription.getBlock();
    }

    public int getHiveMeta() {
        return this.hiveDescription.getMeta();
    }

    public void addDrops(List<IHiveDrop> drops) {
        this.drops.addAll(drops);
    }

    public List<IHiveDrop> getDrops() {
        return this.drops;
    }

    public float genChance() {
        return this.hiveDescription.getGenChance();
    }

    public void postGen(World world, int x, int y, int z) {
        this.hiveDescription.postGen(world, x, y, z);
    }

    public boolean isGoodBiome(BiomeGenBase biome) {
        return this.hiveDescription.isGoodBiome(biome);
    }

    public boolean isGoodHumidity(EnumHumidity humidity) {
        return this.hiveDescription.isGoodHumidity(humidity);
    }

    public boolean isGoodTemperature(EnumTemperature temperature) {
        return this.hiveDescription.isGoodTemperature(temperature);
    }

    public boolean isValidLocation(World world, int x, int y, int z) {
        return this.hiveDescription.getHiveGen().isValidLocation(world, x, y, z);
    }

    public boolean canReplace(World world, int x, int y, int z) {
        return this.hiveDescription.getHiveGen().canReplace(world, x, y, z);
    }

    public int getYForHive(World world, int x, int z) {
        return this.hiveDescription.getHiveGen().getYForHive(world, x, z);
    }
}

