/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiMoistener;
import forestry.factory.tiles.TileMoistener;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerMoistener
extends RecipeHandlerBase {
    @Override
    public String getRecipeID() {
        return "forestry.moistener";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory.4.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/moistener.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(138, 27, 16, 14);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiMoistener.class;
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        this.drawProgressBar(88, 6, 176, 91, 29, 55, 80, 3);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(119, 25, 176, 74, 16, 15, 160, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (TileMoistener.Recipe recipe : TileMoistener.RecipeManager.recipes) {
            for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
                this.arecipes.add(new CachedMoistenerRecipe(recipe, fuel));
            }
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (TileMoistener.Recipe recipe : TileMoistener.RecipeManager.recipes) {
            for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.product, (ItemStack)result) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)fuel.product, (ItemStack)result)) continue;
                this.arecipes.add(new CachedMoistenerRecipe(recipe, fuel));
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (TileMoistener.Recipe recipe : TileMoistener.RecipeManager.recipes) {
            for (MoistenerFuel fuel : FuelManager.moistenerResource.values()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.resource, (ItemStack)ingred) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)fuel.item, (ItemStack)ingred)) continue;
                this.arecipes.add(new CachedMoistenerRecipe(recipe, fuel));
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (ingredient.getFluid() == FluidRegistry.WATER) {
            this.loadAllRecipes();
        }
    }

    public class CachedMoistenerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank tank;
        public List<PositionedStack> fuels = new ArrayList<PositionedStack>();
        public PositionedStack input;
        public PositionedStack output;

        public CachedMoistenerRecipe(TileMoistener.Recipe recipe, MoistenerFuel fuel) {
            this.tank = new PositionedFluidTank(FluidRegistry.getFluidStack((String)"water", (int)10000), 10000, new Rectangle(11, 5, 16, 58), NEIHandlerMoistener.this.getGuiTexture(), new Point(176, 0));
            this.tank.showAmount = false;
            if (fuel.item != null) {
                this.fuels.add(new PositionedStack((Object)fuel.item, 34, 47));
            }
            if (fuel.product != null) {
                this.fuels.add(new PositionedStack((Object)fuel.product, 100, 26));
            }
            if (recipe.resource != null) {
                this.input = new PositionedStack((Object)recipe.resource, 138, 8);
            }
            if (recipe.product != null) {
                this.output = new PositionedStack((Object)recipe.product, 138, 44);
            }
        }

        public List<PositionedStack> getOtherStacks() {
            return this.fuels;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }
    }
}

