/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;

public class PacketGuiUpdate
extends PacketCoordinates {
    private IStreamableGui guiDataTile;

    public static void onPacketData(DataInputStreamForestry data) throws IOException {
        new PacketGuiUpdate(data);
    }

    private PacketGuiUpdate(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketGuiUpdate(IStreamableGui guiDataTile) {
        super(PacketId.TILE_FORESTRY_GUI_OPENED, guiDataTile.getCoordinates());
        this.guiDataTile = guiDataTile;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.guiDataTile.writeGuiData(data);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IStreamableGui) {
            ((IStreamableGui)tile).readGuiData(data);
        }
    }
}

