/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics.alleles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpeciesCustom;
import forestry.api.arboriculture.IGermlingIconProvider;
import forestry.api.arboriculture.ILeafIconProvider;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.core.genetics.alleles.AlleleSpecies;
import forestry.core.render.TextureManager;
import forestry.core.utils.GeneticsUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.EnumPlantType;

public class AlleleTreeSpecies
extends AlleleSpecies
implements IAlleleTreeSpeciesCustom,
IIconProvider {
    private final ITreeGenerator generator;
    private final IGermlingIconProvider germlingIconProvider;
    private final ILeafIconProvider leafIconProvider;
    private final List<IFruitFamily> fruits = new ArrayList<IFruitFamily>();
    private EnumPlantType nativeType = EnumPlantType.Plains;

    public AlleleTreeSpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean isDominant, IClassification branch, String binomial, ILeafIconProvider leafIconProvider, IGermlingIconProvider germlingIconProvider, ITreeGenerator generator) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, isDominant, branch, binomial, false);
        this.generator = generator;
        this.germlingIconProvider = germlingIconProvider;
        this.leafIconProvider = leafIconProvider;
    }

    @Override
    public ITreeRoot getRoot() {
        return TreeManager.treeRoot;
    }

    @Override
    public AlleleTreeSpecies setPlantType(EnumPlantType type) {
        this.nativeType = type;
        return this;
    }

    @Override
    public AlleleTreeSpecies addFruitFamily(IFruitFamily family) {
        this.fruits.add(family);
        return this;
    }

    @Override
    public int getComplexity() {
        return GeneticsUtil.getResearchComplexity(this, EnumTreeChromosome.SPECIES);
    }

    @Override
    public EnumPlantType getPlantType() {
        return this.nativeType;
    }

    public List<IFruitFamily> getSuitableFruit() {
        return this.fruits;
    }

    @Override
    public ITreeGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public IIcon getLeafIcon(boolean pollinated, boolean fancy) {
        return this.leafIconProvider.getIcon(pollinated, fancy);
    }

    @Override
    public int getLeafColour(boolean pollinated) {
        return this.leafIconProvider.getColor(pollinated);
    }

    @Override
    public int getIconColour(int renderPass) {
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.germlingIconProvider.registerIcons(register);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getGermlingIcon(EnumGermlingType type, int renderPass) {
        return this.germlingIconProvider.getIcon(type, renderPass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGermlingColour(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.SAPLING) {
            return 0xFFFFFF;
        }
        return this.getLeafColour(false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(short texUID) {
        return TextureManager.getInstance().getIcon(texUID);
    }
}

