/*
 * Decompiled with CFR 0.152.
 */
package forestry;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.core.ForestryCore;
import forestry.core.config.ForestryItem;
import forestry.core.network.PacketHandler;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import forestry.core.utils.datastructures.FluidMap;
import forestry.core.utils.datastructures.ItemStackMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

@Mod(modid="Forestry", name="Forestry", version="4.0.7.743-unstable", guiFactory="forestry.core.config.ForestryGuiConfigFactory", dependencies="required-after:Forge@[10.13.0.1207,);after:Buildcraft|Core@[6.1.7,);after:ExtrabiomesXL;after:BiomesOPlenty;after:IC2@[2.0.140,);after:Natura@[2.2.0,);after:HardcoreEnderExpansion;")
public class Forestry {
    @Mod.Instance(value="Forestry")
    public static Forestry instance;
    private File configFolder;
    private static final Map<String, ForestryItem> mappedItems;
    @SidedProxy(clientSide="forestry.core.ForestryClient", serverSide="forestry.core.ForestryCore")
    public static ForestryCore core;
    public static PacketHandler packetHandler;

    public Forestry() {
        FuelManager.fermenterFuel = new ItemStackMap<FermenterFuel>();
        FuelManager.moistenerResource = new ItemStackMap<MoistenerFuel>();
        FuelManager.rainSubstrate = new ItemStackMap<RainSubstrate>();
        FuelManager.bronzeEngineFuel = new FluidMap<EngineBronzeFuel>();
        FuelManager.copperEngineFuel = new ItemStackMap<EngineCopperFuel>();
        FuelManager.generatorFuel = new FluidMap<GeneratorFuel>();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        packetHandler = new PacketHandler();
        this.configFolder = new File(event.getModConfigurationDirectory(), "forestry");
        core.preInit(event.getSourceFile(), this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        core.init(this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        core.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        core.serverStarting(event.getServer());
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        core.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            Block block;
            if (mapping.type == GameRegistry.Type.BLOCK) {
                block = GameRegistry.findBlock((String)"Forestry", (String)StringUtil.cleanTags(mapping.name));
                if (block == null) continue;
                mapping.remap(block);
                Log.warning("Remapping block " + mapping.name + " to " + StringUtil.cleanBlockName(block));
                continue;
            }
            block = GameRegistry.findBlock((String)"Forestry", (String)StringUtil.cleanTags(mapping.name));
            if (block != null) {
                mapping.remap(Item.getItemFromBlock((Block)block));
                Log.warning("Remapping item " + mapping.name + " to " + StringUtil.cleanBlockName(block));
                continue;
            }
            ForestryItem mappedItem = mappedItems.get(mapping.name);
            if (mappedItem == null) continue;
            mapping.remap(mappedItem.item());
            Log.warning("Remapping item " + mapping.name + " to " + mappedItem.name());
        }
    }

    static {
        mappedItems = new HashMap<String, ForestryItem>();
        mappedItems.put("Forestry:builderBackpack", ForestryItem.builderBackpack);
        mappedItems.put("Forestry:builderBackpackT2", ForestryItem.builderBackpackT2);
        mappedItems.put("Forestry:adventurerBackpack", ForestryItem.adventurerBackpack);
        mappedItems.put("Forestry:adventurerBackpackT2", ForestryItem.adventurerBackpackT2);
        mappedItems.put("Forestry:shortMead", ForestryItem.beverage);
        mappedItems.put("Forestry:waterCan", ForestryItem.canWater);
        mappedItems.put("Forestry:biofuelCan", ForestryItem.canEthanol);
        mappedItems.put("Forestry:biomassCan", ForestryItem.canBiomass);
        mappedItems.put("Forestry:bucketBiofuel", ForestryItem.bucketEthanol);
        mappedItems.put("Forestry:refractoryBiofuel", ForestryItem.refractoryEthanol);
        mappedItems.put("Forestry:waxCapsuleBiofuel", ForestryItem.waxCapsuleEthanol);
        core = new ForestryCore();
    }
}

