/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.proxy;

import cpw.mods.fml.client.registry.RenderingRegistry;
import forestry.apiculture.entities.EntityBee;
import forestry.apiculture.entities.EntityFXBee;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.render.ParticleRenderer;
import forestry.apiculture.render.RenderBeeEntity;
import forestry.apiculture.render.RenderBeeItem;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.ProxyRenderClient;
import forestry.core.render.IBlockRenderer;
import forestry.core.render.RenderAnalyzer;
import forestry.core.render.TextureManager;
import forestry.plugins.PluginApiculture;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.item.Item;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ProxyApicultureClient
extends ProxyApiculture {
    @Override
    public void initializeRendering() {
        if (PluginApiculture.fancyRenderedBees) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBee.class, (Render)new RenderBeeEntity());
            MinecraftForgeClient.registerItemRenderer((Item)ForestryItem.beeDroneGE.item(), (IItemRenderer)new RenderBeeItem());
            MinecraftForgeClient.registerItemRenderer((Item)ForestryItem.beePrincessGE.item(), (IItemRenderer)new RenderBeeItem());
            MinecraftForgeClient.registerItemRenderer((Item)ForestryItem.beeQueenGE.item(), (IItemRenderer)new RenderBeeItem());
        }
    }

    @Override
    public void addBeeHiveFX(String icon, World world, ChunkCoordinates coordinates, int color) {
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        EntityFXBee fx = new EntityFXBee(world, (double)coordinates.posX + 0.5, (double)coordinates.posY + 0.5, (double)coordinates.posZ + 0.5, color);
        fx.setParticleIcon(TextureManager.getInstance().getDefault(icon));
        ParticleRenderer.getInstance().addEffect(fx);
    }

    @Override
    public void addBeeSwarmFX(String icon, World world, double xCoord, double yCoord, double zCoord, int color) {
        EntityFXBee fx;
        if (!ProxyRenderClient.shouldSpawnParticle(world)) {
            return;
        }
        if (world.rand.nextBoolean()) {
            fx = new EntityFXBee(world, xCoord, yCoord, zCoord, color);
        } else {
            double spawnX = xCoord + (double)world.rand.nextInt(4) - 2.0;
            double spawnY = yCoord + (double)world.rand.nextInt(4) - 2.0;
            double spawnZ = zCoord + (double)world.rand.nextInt(4) - 2.0;
            fx = new EntityFXBee(world, spawnX, spawnY, spawnZ, color);
        }
        fx.setParticleIcon(TextureManager.getInstance().getDefault(icon));
        ParticleRenderer.getInstance().addEffect(fx);
    }

    @Override
    public IBlockRenderer getRendererAnalyzer(String gfxBase) {
        return new RenderAnalyzer(gfxBase);
    }
}

