/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.storage.ICrateRegistry;
import forestry.core.items.ItemCrated;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.plugins.PluginStorage;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CrateRegistry
implements ICrateRegistry {
    private static void registerCrate(ItemStack stack, String uid, boolean useOreDict) {
        if (stack == null || stack.getItem() == null) {
            Log.severe("Tried to make a crate without an item");
            return;
        }
        if (uid == null) {
            Log.severe("Tried to make a crate without a uid");
            return;
        }
        ItemCrated crate = new ItemCrated(stack, useOreDict);
        crate.setUnlocalizedName(uid);
        Proxies.common.registerItem(crate);
        PluginStorage.registerCrate(crate);
    }

    @Override
    public void registerCrate(Item item, String uid) {
        CrateRegistry.registerCrate(new ItemStack(item), uid, false);
    }

    @Override
    public void registerCrateUsingOreDict(Item item, String uid) {
        CrateRegistry.registerCrate(new ItemStack(item), uid, true);
    }

    @Override
    public void registerCrate(Block block, String uid) {
        CrateRegistry.registerCrate(new ItemStack(block), uid, false);
    }

    @Override
    public void registerCrateUsingOreDict(Block block, String uid) {
        CrateRegistry.registerCrate(new ItemStack(block), uid, true);
    }

    @Override
    public void registerCrate(ItemStack stack, String uid) {
        CrateRegistry.registerCrate(stack, uid, false);
    }

    @Override
    public void registerCrateUsingOreDict(ItemStack stack, String uid) {
        CrateRegistry.registerCrate(stack, uid, true);
    }
}

