/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectNone;
import forestry.core.genetics.EffectData;

public abstract class AlleleEffectThrottled
extends AlleleEffectNone {
    private boolean isCombinable = false;
    private final int throttle;
    private boolean requiresWorkingQueen = false;

    protected AlleleEffectThrottled(String name, boolean isDominant, int throttle, boolean requiresWorking, boolean isCombinable) {
        super(name, isDominant);
        this.throttle = throttle;
        this.isCombinable = isCombinable;
        this.requiresWorkingQueen = requiresWorking;
    }

    @Override
    public boolean isCombinable() {
        return this.isCombinable;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData) {
            return storedData;
        }
        return new EffectData(1, 0);
    }

    @Override
    public final IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.isThrottled(storedData, housing)) {
            return storedData;
        }
        return this.doEffectThrottled(genome, storedData, housing);
    }

    private boolean isThrottled(IEffectData storedData, IBeeHousing housing) {
        if (this.requiresWorkingQueen && housing.getErrorLogic().hasErrors()) {
            return true;
        }
        int time = storedData.getInteger(0);
        storedData.setInteger(0, ++time);
        if (time < this.throttle) {
            return true;
        }
        storedData.setInteger(0, 0);
        return false;
    }

    abstract IEffectData doEffectThrottled(IBeeGenome var1, IEffectData var2, IBeeHousing var3);
}

