/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.proxy.Proxies;
import forestry.food.items.ItemInfuser.InfuserInventory;

public class ContainerInfuser extends ContainerItemInventory<InfuserInventory> {

	public ContainerInfuser(InventoryPlayer inventoryplayer, InfuserInventory inventory) {
		super(inventory, inventoryplayer, 8, 103);

		// Input
		this.addSlotToContainer(new SlotFiltered(inventory, 0, 152, 12));

		// Output
		this.addSlotToContainer(new SlotOutput(inventory, 1, 152, 72));

		// Ingredients
		this.addSlotToContainer(new SlotFiltered(inventory, 2, 12, 12));
		this.addSlotToContainer(new SlotFiltered(inventory, 3, 12, 32));
		this.addSlotToContainer(new SlotFiltered(inventory, 4, 12, 52));
		this.addSlotToContainer(new SlotFiltered(inventory, 5, 12, 72));
	}

	@Override
	public void onContainerClosed(EntityPlayer entityplayer) {

		if (entityplayer.worldObj.isRemote) {
			return;
		}

		// Drop everything still in there.
		for (int i = 0; i < inventory.getSizeInventory(); i++) {
			ItemStack stack = inventory.getStackInSlot(i);
			if (stack == null) {
				continue;
			}

			Proxies.common.dropItemPlayer(entityplayer, stack);
			inventory.setInventorySlotContents(i, null);
		}
	}
}
