/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.items.ItemBlockForestry;
import forestry.core.utils.StringUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemBlockWood
extends ItemBlockForestry {
    public ItemBlockWood(Block block) {
        super(block);
    }

    public static boolean placeWood(ItemStack stack, @Nullable EntityPlayer player, World world, int x, int y, int z, int metadata) {
        EnumWoodType woodType = EnumWoodType.getFromCompound(stack.getTagCompound());
        Block block = Block.getBlockFromItem((Item)stack.getItem());
        boolean placed = world.setBlock(x, y, z, block, metadata, 3);
        if (!placed) {
            return false;
        }
        Block worldBlock = world.getBlock(x, y, z);
        if (!Block.isEqualTo((Block)block, (Block)worldBlock)) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileWood)) {
            world.setBlockToAir(x, y, z);
            return false;
        }
        if (player != null) {
            worldBlock.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            worldBlock.onPostBlockPlaced(world, x, y, z, metadata);
        }
        ((TileWood)tile).setWoodType(woodType);
        return true;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return ItemBlockWood.placeWood(stack, player, world, x, y, z, metadata);
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        String displayName;
        Block block = this.getBlock();
        if (!(block instanceof IWoodTyped)) {
            return super.getItemStackDisplayName(itemstack);
        }
        EnumWoodType woodType = EnumWoodType.getFromCompound(itemstack.getTagCompound());
        if (woodType == null) {
            return super.getItemStackDisplayName(itemstack);
        }
        IWoodTyped wood = (IWoodTyped)block;
        String blockKind = wood.getBlockKind();
        String customUnlocalizedName = blockKind + "." + woodType.ordinal() + ".name";
        if (StringUtil.canTranslateTile(customUnlocalizedName)) {
            displayName = StringUtil.localizeTile(customUnlocalizedName);
        } else {
            String woodGrammar = StringUtil.localize(blockKind + ".grammar");
            String woodTypeName = StringUtil.localize("trees.woodType." + (Object)((Object)woodType));
            displayName = woodGrammar.replaceAll("%TYPE", woodTypeName);
        }
        if (wood.isFireproof()) {
            displayName = StringUtil.localizeAndFormatRaw("tile.for.fireproof", displayName);
        }
        return displayName;
    }
}

