/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.tiles.TileAbstractBeeHousing;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.GuiId;
import forestry.core.utils.SlotUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileApiary
extends TileAbstractBeeHousing {
    private static final IBeeModifier beeModifier = new ApiaryBeeModifier();
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    private final ApiaryInventory inventory;

    public TileApiary() {
        ApiaryInventory apiaryInventory;
        this.inventory = apiaryInventory = new ApiaryInventory(this, 12, "Items");
        this.setInternalInventory(apiaryInventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.ApiaryGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(beeModifier);
        for (IHiveFrame frame : this.inventory.getFrames()) {
            beeModifiers.add(frame.getBeeModifier());
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(ApicultureTriggers.missingQueen);
        res.add(ApicultureTriggers.missingDrone);
        res.add(ApicultureTriggers.noFrames);
        return res;
    }

    public static class ApiaryInventory
    extends TileAbstractBeeHousing.TileBeeHousingInventory {
        public static final int SLOT_FRAMES_1 = 9;
        public static final int SLOT_FRAMES_COUNT = 3;

        public ApiaryInventory(TileApiary tile, int size, String name) {
            super(tile, size, name);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
                return itemStack.getItem() instanceof IHiveFrame && this.getStackInSlot(slotIndex) == null;
            }
            return super.canSlotAccept(slotIndex, itemStack);
        }

        @Override
        public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
            if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
                return false;
            }
            return super.isItemValidForSlot(slotIndex, itemStack);
        }

        public IInventory getFrameInventory() {
            return new InventoryMapper((IInventory)this, 9, 3);
        }

        public Collection<IHiveFrame> getFrames() {
            ArrayList<IHiveFrame> hiveFrames = new ArrayList<IHiveFrame>(3);
            for (int i = 9; i < 12; ++i) {
                Item itemInSlot;
                ItemStack stackInSlot = this.getStackInSlot(i);
                if (stackInSlot == null || !((itemInSlot = stackInSlot.getItem()) instanceof IHiveFrame)) continue;
                hiveFrames.add((IHiveFrame)itemInSlot);
            }
            return hiveFrames;
        }
    }

    private static class ApiaryBeeListener
    extends DefaultBeeListener {
        private final TileApiary apiary;

        public ApiaryBeeListener(TileApiary apiary) {
            this.apiary = apiary;
        }

        @Override
        public void wearOutEquipment(int amount) {
            IBeekeepingMode beekeepingMode = BeeManager.beeRoot.getBeekeepingMode(this.apiary.getWorldObj());
            int wear = Math.round((float)amount * beekeepingMode.getWearModifier());
            IInventory framesInventory = this.apiary.inventory.getFrameInventory();
            for (int i = 0; i < framesInventory.getSizeInventory(); ++i) {
                Item hiveFrameItem;
                ItemStack hiveFrameStack = framesInventory.getStackInSlot(i);
                if (hiveFrameStack == null || !((hiveFrameItem = hiveFrameStack.getItem()) instanceof IHiveFrame)) continue;
                IHiveFrame hiveFrame = (IHiveFrame)hiveFrameItem;
                ItemStack queenStack = this.apiary.getBeeInventory().getQueen();
                IBee queen = BeeManager.beeRoot.getMember(queenStack);
                ItemStack usedFrame = hiveFrame.frameUsed(this.apiary, hiveFrameStack, queen, wear);
                framesInventory.setInventorySlotContents(i, usedFrame);
            }
        }
    }

    private static class ApiaryBeeModifier
    extends DefaultBeeModifier {
        private ApiaryBeeModifier() {
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.1f;
        }
    }
}

