/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.core.blocks.BlockBase;
import forestry.core.config.ForestryBlock;
import forestry.core.config.GameMode;
import forestry.core.items.ItemBlockForestry;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.tiles.MachineDefinition;
import forestry.energy.GuiHandlerEnergy;
import forestry.energy.proxy.ProxyEnergy;
import forestry.energy.tiles.EngineDefinition;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineClockwork;
import forestry.energy.tiles.TileEnginePeat;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

@Plugin(pluginID="Energy", name="Energy", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.energy.description")
public class PluginEnergy
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.energy.proxy.ProxyEnergyClient", serverSide="forestry.energy.proxy.ProxyEnergy")
    public static ProxyEnergy proxy;
    private static MachineDefinition definitionEnginePeat;
    private static MachineDefinition definitionEngineBiogas;
    private static MachineDefinition definitionEngineClockwork;

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.engine.registerBlock((Block)new BlockBase(Material.iron, true), ItemBlockForestry.class, "engine");
        definitionEnginePeat = ((BlockBase)ForestryBlock.engine.block()).addDefinition(new EngineDefinition(1, "forestry.EngineCopper", TileEnginePeat.class, proxy.getRenderDefaultEngine("textures/blocks/engine_copper_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.engine.getItemStack(1, 1), "###", " X ", "YVY", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "gearCopper", Character.valueOf('V'), Blocks.piston)));
        definitionEngineBiogas = ((BlockBase)ForestryBlock.engine.block()).addDefinition(new EngineDefinition(2, "forestry.EngineBronze", TileEngineBiogas.class, proxy.getRenderDefaultEngine("textures/blocks/engine_bronze_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.engine.getItemStack(1, 2), "###", " X ", "YVY", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "gearBronze", Character.valueOf('V'), Blocks.piston)));
        ShapedRecipeCustom clockworkRecipe = null;
        if (GameMode.getGameMode().getBooleanSetting("energy.engine.clockwork")) {
            clockworkRecipe = ShapedRecipeCustom.createShapedRecipe(ForestryBlock.engine.getItemStack(1, 4), "###", " X ", "ZVY", Character.valueOf('#'), "plankWood", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), Items.clock, Character.valueOf('Z'), "gearCopper", Character.valueOf('V'), Blocks.piston);
        }
        definitionEngineClockwork = ((BlockBase)ForestryBlock.engine.block()).addDefinition(new EngineDefinition(4, "forestry.EngineClockwork", TileEngineClockwork.class, proxy.getRenderDefaultEngine("textures/blocks/engine_clock_"), clockworkRecipe));
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionEnginePeat.register();
        definitionEngineBiogas.register();
        definitionEngineClockwork.register();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerEnergy();
    }
}

