/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.core.recipes.nei.IRecipeHandlerBase;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.PositionedStackAdv;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class RecipeHandlerBase
extends TemplateRecipeHandler
implements IRecipeHandlerBase {
    @Override
    public void prepare() {
    }

    public abstract String getRecipeID();

    public String getRecipeSubName() {
        return null;
    }

    public void changeToGuiTexture() {
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addTransferRect(int x, int y, int width, int height) {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(x, y, width, height), this.getRecipeID(), new Object[0]));
    }

    public void drawForeground(int recipe) {
        super.drawForeground(recipe);
        this.drawFluidTanks(recipe);
        if (recipe % this.recipiesPerPage() == 0 && this.getRecipeSubName() != null) {
            GuiDraw.drawStringC((String)this.getRecipeSubName(), (int)83, (int)-2, (int)0x404040, (boolean)false);
        }
        this.changeToGuiTexture();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("liquid") && results[0] instanceof FluidStack && ((FluidStack)results[0]).getFluid() != null) {
            this.loadCraftingRecipes((FluidStack)results[0]);
        } else if (outputId.equals(this.getRecipeID())) {
            this.loadAllRecipes();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadAllRecipes() {
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack fluid = NEIUtils.getFluidStack(result);
        if (fluid != null && fluid.getFluid() != null) {
            this.loadCraftingRecipes(fluid);
        }
    }

    public void loadCraftingRecipes(FluidStack result) {
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients[0] instanceof FluidStack && ((FluidStack)ingredients[0]).getFluid() != null) {
            this.loadUsageRecipes((FluidStack)ingredients[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        FluidStack fluid = NEIUtils.getFluidStack(ingred);
        if (fluid != null && fluid.getFluid() != null) {
            this.loadUsageRecipes(fluid);
        }
    }

    public void loadUsageRecipes(FluidStack ingredient) {
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        super.handleTooltip(guiRecipe, currenttip, recipe);
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)guiRecipe)) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mouse.x - (guiRecipe.width - 176) / 2 - offset.x, mouse.y - (guiRecipe.height - 166) / 2 - offset.y);
            currenttip = this.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        }
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe guiRecipe, ItemStack itemStack, List<String> currenttip, int recipe) {
        super.handleItemTooltip(guiRecipe, itemStack, currenttip, recipe);
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        Point mouse = GuiDraw.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - (guiRecipe.width - 176) / 2 - offset.x, mouse.y - (guiRecipe.height - 166) / 2 - offset.y);
        currenttip = this.provideItemTooltip(guiRecipe, itemStack, currenttip, crecipe, relMouse);
        return currenttip;
    }

    public List<String> provideTooltip(GuiRecipe guiRecipe, List<String> currenttip, CachedBaseRecipe crecipe, Point relMouse) {
        if (crecipe.getFluidTanks() != null) {
            for (PositionedFluidTank tank : crecipe.getFluidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public List<String> provideItemTooltip(GuiRecipe guiRecipe, ItemStack itemStack, List<String> currenttip, CachedBaseRecipe crecipe, Point relMouse) {
        for (PositionedStack stack : crecipe.getIngredients()) {
            if (!(stack instanceof PositionedStackAdv) || !((PositionedStackAdv)stack).getRect().contains(relMouse)) continue;
            currenttip = ((PositionedStackAdv)stack).handleTooltip(guiRecipe, currenttip);
        }
        for (PositionedStack stack : crecipe.getOtherStacks()) {
            if (!(stack instanceof PositionedStackAdv) || !((PositionedStackAdv)stack).getRect().contains(relMouse)) continue;
            currenttip = ((PositionedStackAdv)stack).handleTooltip(guiRecipe, currenttip);
        }
        PositionedStack stack = crecipe.getResult();
        if (stack instanceof PositionedStackAdv && ((PositionedStackAdv)stack).getRect().contains(relMouse)) {
            currenttip = ((PositionedStackAdv)stack).handleTooltip(guiRecipe, currenttip);
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.transferFluidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferFluidTank(gui, recipe, false) : button == 1 && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    protected boolean transferFluidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        Point mousepos = GuiDraw.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mousepos.x - (guiRecipe.width - 176) / 2 - offset.x, mousepos.y - (guiRecipe.height - 166) / 2 - offset.y);
        if (crecipe.getFluidTanks() != null) {
            for (PositionedFluidTank tank : crecipe.getFluidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                return tank.transfer(usage);
            }
        }
        return false;
    }

    public void drawFluidTanks(int recipe) {
        CachedBaseRecipe crecipe;
        TemplateRecipeHandler.CachedRecipe cachedRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (cachedRecipe instanceof CachedBaseRecipe && (crecipe = (CachedBaseRecipe)cachedRecipe).getFluidTanks() != null) {
            for (PositionedFluidTank fluidTank : crecipe.getFluidTanks()) {
                fluidTank.draw();
            }
        }
    }

    public abstract class CachedBaseRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public CachedBaseRecipe() {
            super((TemplateRecipeHandler)RecipeHandlerBase.this);
        }

        public List<PositionedFluidTank> getFluidTanks() {
            ArrayList<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();
            PositionedFluidTank tank = this.getFluidTank();
            if (tank != null) {
                tanks.add(tank);
            }
            return tanks;
        }

        public PositionedFluidTank getFluidTank() {
            return null;
        }
    }
}

