/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.world.World;

public class WorldGenCrescentia
extends WorldGenTree {
    public WorldGenCrescentia(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        if (world.rand.nextBoolean()) {
            this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
    }

    @Override
    protected void generateTreeTrunk(World world, int height, int girth) {
        int offset = (girth - 1) / 2;
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                if (x == 0 || x == girth - 1) {
                    if (z == 0 || z == girth - 1) {
                        if (x != 0 || z == 0) {
                            // empty if block
                        }
                        if (x != girth - 1 || z == 0) {
                            // empty if block
                        }
                        if (x != 0 || z == girth - 1) {
                            // empty if block
                        }
                        if (x != girth - 1 || z != 0) continue;
                        continue;
                    }
                    if (x == 0 || x != girth - 1) continue;
                    continue;
                }
                if (z == 0 || z == girth - 1) {
                    if (z == 0 || z != girth - 1) continue;
                    continue;
                }
                for (int i = 0; i < height; ++i) {
                    this.addWood(world, x - offset, i, z - offset, WorldGenBase.EnumReplaceMode.ALL);
                }
            }
        }
        this.generatePods(world, height, girth);
    }
}

