/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockWood;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockArbFence
extends BlockFence
implements IWoodTyped,
ITileEntityProvider {
    private final boolean fireproof;

    public BlockArbFence(boolean fireproof) {
        super("", Material.wood);
        this.fireproof = fireproof;
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setHarvestLevel("axe", 0);
        this.setStepSound(soundTypeWood);
        this.setCreativeTab(Tabs.tabArboriculture);
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List list) {
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            list.add(TreeManager.woodItemAccess.getFence(woodType, this.fireproof));
        }
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean canConnectFenceTo(IBlockAccess world, int x, int y, int z) {
        if (!BlockArbFence.isFence(world, x, y, z)) {
            Block block = world.getBlock(x, y, z);
            if (block == this || block instanceof BlockFenceGate) {
                return true;
            }
            return block.getMaterial().isOpaque() && block.renderAsNormalBlock() && block.getMaterial() != Material.gourd;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        IconProviderWood.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return IconProviderWood.getPlankIcon(EnumWoodType.LARCH);
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileWood wood = BlockWood.getWoodTile(world, x, y, z);
        EnumWoodType woodType = wood.getWoodType();
        return IconProviderWood.getPlankIcon(woodType);
    }

    private static boolean isFence(IBlockAccess world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        return PluginArboriculture.validFences.contains(block);
    }

    public final TileEntity createNewTileEntity(World world, int meta) {
        return new TileWood();
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = new ItemStack((Block)this);
        NBTTagCompound nbt = BlockWood.getTagCompound((IBlockAccess)world, x, y, z);
        itemStack.setTagCompound(nbt);
        return itemStack;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return TileWood.blockRemovedByPlayer(this, world, player, x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        world.removeTileEntity(x, y, z);
        super.breakBlock(world, x, y, z, block, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public final float getBlockHardness(World world, int x, int y, int z) {
        TileWood wood = BlockWood.getWoodTile((IBlockAccess)world, x, y, z);
        if (wood == null) {
            return 2.0f;
        }
        return wood.getWoodType().getHardness();
    }

    public final boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return !this.isFireproof();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 5;
    }

    @Override
    public String getBlockKind() {
        return "fences";
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }
}

