/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.farming.Farmables;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.config.ForestryItem;
import forestry.core.config.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Natura", name="Natura", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.natura.description")
public class PluginNatura
extends ForestryPlugin {
    private static final String NATURA = "Natura";
    private static Block logNatura;
    private static Block logWillow;
    private static Block leavesNatura;
    private static Block saplingNatura;
    private static Block saplingNaturaRare;
    private static ItemStack berryBlight;
    private static ItemStack berryDusk;
    private static ItemStack berrySky;
    private static ItemStack berrySting;
    private static ItemStack berryRasp;
    private static ItemStack berryBlue;
    private static ItemStack berryBlack;
    private static ItemStack berryMalo;
    private static ItemStack itemBarley;

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(NATURA);
    }

    @Override
    public String getFailMessage() {
        return "Natura not found";
    }

    @Override
    public void preInit() {
        super.preInit();
        logNatura = GameRegistry.findBlock((String)NATURA, (String)"tree");
        logWillow = GameRegistry.findBlock((String)NATURA, (String)"willow");
        leavesNatura = GameRegistry.findBlock((String)NATURA, (String)"floraleaves");
        saplingNatura = GameRegistry.findBlock((String)NATURA, (String)"florasapling");
        saplingNaturaRare = GameRegistry.findBlock((String)NATURA, (String)"Rare Sapling");
        ArrayList<String> saplingItemKeys = new ArrayList<String>();
        if (saplingNatura != null) {
            saplingItemKeys.add("florasapling");
        }
        if (saplingNaturaRare != null) {
            saplingItemKeys.add("Rare Sapling");
        }
        for (String key : saplingItemKeys) {
            Item saplingItem = GameRegistry.findItem((String)NATURA, (String)key);
            ItemStack saplingWild = new ItemStack(saplingItem, 1, Short.MAX_VALUE);
            RecipeUtil.addFermenterRecipes(saplingWild, GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
            String saplingName = GameData.getItemRegistry().getNameForObject((Object)saplingItem);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        }
        berryBlight = GameRegistry.findItemStack((String)NATURA, (String)"berryBlight", (int)1);
        berryDusk = GameRegistry.findItemStack((String)NATURA, (String)"berryDusk", (int)1);
        berrySky = GameRegistry.findItemStack((String)NATURA, (String)"berrySky", (int)1);
        berrySting = GameRegistry.findItemStack((String)NATURA, (String)"berrySting", (int)1);
        berryRasp = GameRegistry.findItemStack((String)NATURA, (String)"berryRasp", (int)1);
        berryBlue = GameRegistry.findItemStack((String)NATURA, (String)"berryBlue", (int)1);
        berryBlack = GameRegistry.findItemStack((String)NATURA, (String)"berryBlack", (int)1);
        berryMalo = GameRegistry.findItemStack((String)NATURA, (String)"berryMalo", (int)1);
        itemBarley = GameRegistry.findItemStack((String)NATURA, (String)"barleyFood", (int)1);
    }

    @Override
    protected void registerCrates() {
        Item taintedSoil;
        Item heatSand;
        Item darkTree;
        Item bloodWood;
        Item glowShroom;
        Item potashApple;
        super.registerCrates();
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        if (berryBlight != null) {
            crateRegistry.registerCrate(berryBlight, "cratedNaturaBerryBlight");
        }
        if (berryDusk != null) {
            crateRegistry.registerCrate(berryDusk, "cratedNaturaBerryDusk");
        }
        if (berrySky != null) {
            crateRegistry.registerCrate(berrySky, "cratedNaturaBerrySky");
        }
        if (berrySting != null) {
            crateRegistry.registerCrate(berrySting, "cratedNaturaBerrySting");
        }
        if (berryRasp != null) {
            crateRegistry.registerCrate(berryRasp, "cratedNaturaBerryRasp");
        }
        if (berryBlue != null) {
            crateRegistry.registerCrate(berryBlue, "cratedNaturaBerryBlue");
        }
        if (berryBlack != null) {
            crateRegistry.registerCrate(berryBlack, "cratedNaturaBerryBlack");
        }
        if (berryMalo != null) {
            crateRegistry.registerCrate(berryMalo, "cratedNaturaBerryMalo");
        }
        if (itemBarley != null) {
            crateRegistry.registerCrate(itemBarley, "cratedNaturaBarley");
        }
        if (saplingNatura != null) {
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 0), "cratedNaturaSaplingRedwood");
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 1), "cratedNaturaSaplingEucalyptus");
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 2), "cratedNaturaSaplingHopseed");
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 3), "cratedNaturaSaplingSakura");
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 4), "cratedNaturaSaplingGhostwood");
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 5), "cratedNaturaSaplingBlood");
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 6), "cratedNaturaSaplingDarkwood");
            crateRegistry.registerCrate(new ItemStack(saplingNatura, 1, 7), "cratedNaturaSaplingFusewood");
        }
        if (saplingNaturaRare != null) {
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 0), "cratedNaturaSaplingMaple");
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 1), "cratedNaturaSaplingSilverbell");
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 2), "cratedNaturaSaplingPurpleheart");
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 3), "cratedNaturaSaplingTiger");
            crateRegistry.registerCrate(new ItemStack(saplingNaturaRare, 1, 4), "cratedNaturaSaplingWillow");
        }
        if ((potashApple = GameRegistry.findItem((String)NATURA, (String)"Natura.netherfood")) != null) {
            crateRegistry.registerCrate(new ItemStack(potashApple, 1, 0), "cratedNaturaPotashApple");
        }
        if ((glowShroom = GameRegistry.findItem((String)NATURA, (String)"Glowshroom")) != null) {
            crateRegistry.registerCrate(new ItemStack(glowShroom, 1, 0), "cratedNaturaGreenGlowshroom");
            crateRegistry.registerCrate(new ItemStack(glowShroom, 1, 1), "cratedNaturaPurpleGlowshroom");
            crateRegistry.registerCrate(new ItemStack(glowShroom, 1, 2), "cratedNaturaBlueGlowshroom");
        }
        if (logNatura != null) {
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 0), "cratedNaturaLogEucalyptus");
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 1), "cratedNaturaLogSakura");
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 2), "cratedNaturaLogGhostwood");
            crateRegistry.registerCrate(new ItemStack(logNatura, 1, 3), "cratedNaturaLogHopseed");
            crateRegistry.registerCrate(new ItemStack(logWillow, 1, 0), "cratedNaturaLogWillow");
        }
        if ((bloodWood = GameRegistry.findItem((String)NATURA, (String)"bloodwood")) != null) {
            crateRegistry.registerCrate(new ItemStack(bloodWood, 1, 0), "cratedNaturaLogBloodwood");
        }
        if ((darkTree = GameRegistry.findItem((String)NATURA, (String)"Dark Tree")) != null) {
            crateRegistry.registerCrate(new ItemStack(darkTree, 1, 0), "cratedNaturaLogDarkwood");
            crateRegistry.registerCrate(new ItemStack(darkTree, 1, 1), "cratedNaturaLogFusewood");
        }
        if ((heatSand = GameRegistry.findItem((String)NATURA, (String)"heatsand")) != null) {
            crateRegistry.registerCrate(new ItemStack(heatSand, 1, 0), "cratedNaturaBlockHeatsand");
        }
        if ((taintedSoil = GameRegistry.findItem((String)NATURA, (String)"soil.tainted")) != null) {
            crateRegistry.registerCrate(new ItemStack(taintedSoil, 1, 0), "cratedNaturaBlockTainted");
        }
    }

    @Override
    protected void registerRecipes() {
        ItemStack seedBarley = GameRegistry.findItemStack((String)NATURA, (String)"seedBarley", (int)1);
        ItemStack seedCotton = GameRegistry.findItemStack((String)NATURA, (String)"seedCotton", (int)1);
        ArrayList<ItemStack> seedList = new ArrayList<ItemStack>();
        if (seedBarley != null) {
            seedList.add(seedBarley);
            RecipeManagers.moistenerManager.addRecipe(seedBarley, new ItemStack((Block)Blocks.mycelium), 5000);
        }
        if (seedCotton != null) {
            seedList.add(seedCotton);
        }
        int amount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        for (ItemStack aSeedList : seedList) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{aSeedList}, Fluids.SEEDOIL.getFluid(amount));
        }
        Block cropBlock = GameRegistry.findBlock((String)NATURA, (String)"N Crops");
        Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(seedBarley, cropBlock, 3, new ItemStack[0]));
        Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(seedCotton, cropBlock, 8, new ItemStack[0]));
        ArrayList<ItemStack> berries = new ArrayList<ItemStack>();
        if (berryBlight != null) {
            berries.add(berryBlight);
        }
        if (berryDusk != null) {
            berries.add(berryDusk);
        }
        if (berrySky != null) {
            berries.add(berrySky);
        }
        if (berrySting != null) {
            berries.add(berrySting);
        }
        if (berryRasp != null) {
            berries.add(berryRasp);
        }
        if (berryBlue != null) {
            berries.add(berryBlue);
        }
        if (berryBlack != null) {
            berries.add(berryBlack);
        }
        if (berryMalo != null) {
            berries.add(berryMalo);
        }
        amount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") / 2;
        amount = Math.max(amount, 1);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(GameRegistry.findItem((String)NATURA, (String)"Natura.netherfood"), 1, 0)}, Fluids.JUICE.getFluid(amount), ForestryItem.mulch.getItemStack(), GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple"));
        amount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") / 25;
        amount = Math.max(amount, 1);
        for (ItemStack berry : berries) {
            RecipeManagers.squeezerManager.addRecipe(3, new ItemStack[]{berry}, Fluids.JUICE.getFluid(amount));
        }
        if (itemBarley != null) {
            RecipeUtil.addFermenterRecipes(itemBarley, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
            if (GameMode.getGameMode().getStackSetting((String)"recipe.output.compost.wheat").stackSize > 0) {
                ItemStack compostWheat = GameMode.getGameMode().getStackSetting("recipe.output.compost.wheat");
                Proxies.common.addRecipe(compostWheat, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), itemBarley);
            }
            FuelManager.moistenerResource.put(itemBarley, new MoistenerFuel(itemBarley, ForestryItem.mouldyWheat.getItemStack(), 0, 300));
        }
    }
}

