/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.FarmHelper;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class FarmLogicHomogeneous
extends FarmLogic {
    private final ItemStack resource;
    private final ItemStack soilBlock;
    protected final Iterable<IFarmable> germlings;
    ArrayList<ItemStack> produce = new ArrayList();

    protected FarmLogicHomogeneous(IFarmHousing housing, ItemStack resource, ItemStack soilBlock, Iterable<IFarmable> germlings) {
        super(housing);
        this.resource = resource;
        this.soilBlock = soilBlock;
        this.germlings = germlings;
    }

    protected boolean isAcceptedSoil(ItemStack itemStack) {
        return ItemStackUtil.isIdenticalItem(this.soilBlock, itemStack);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource.isItemEqual(itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    protected boolean isWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(int x, int y, int z, FarmDirection direction, int extent) {
        if (this.maintainSoil(x, y, z, direction, extent)) {
            return true;
        }
        return this.maintainGermlings(x, y + 1, z, direction, extent);
    }

    private boolean maintainSoil(int x, int yGround, int z, FarmDirection direction, int extent) {
        Vect position;
        Block soil;
        ItemStack[] resources = new ItemStack[]{this.resource};
        if (!this.housing.getFarmInventory().hasResources(resources)) {
            return false;
        }
        World world = this.getWorld();
        for (int i = 0; i < extent && !FarmHelper.bricks.contains((Object)(soil = VectUtil.getBlock(world, position = this.translateWithOffset(x, yGround, z, direction, i)))); ++i) {
            ItemStack soilStack = VectUtil.getAsItemStack(world, position);
            if (this.isAcceptedSoil(soilStack)) continue;
            Vect platformPosition = position.add(0, -1, 0);
            Block platformBlock = VectUtil.getBlock(world, platformPosition);
            if (!FarmHelper.bricks.contains((Object)platformBlock)) break;
            this.produce.addAll(BlockUtil.getBlockDrops(world, position));
            this.setBlock(position, ItemStackUtil.getBlock(this.soilBlock), this.soilBlock.getItemDamage());
            this.housing.getFarmInventory().removeResources(resources);
            return true;
        }
        return false;
    }

    protected abstract boolean maintainGermlings(int var1, int var2, int var3, FarmDirection var4, int var5);
}

