/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.core.circuits.ISocketable;
import forestry.core.gui.IContainerSocketed;
import forestry.core.network.PacketId;
import forestry.core.network.PacketSlotClick;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ContainerSocketedHelper<T extends TileEntity>
implements IContainerSocketed {
    private final T tile;

    public ContainerSocketedHelper(T tile) {
        this.tile = tile;
    }

    @Override
    public void handleChipsetClick(int slot) {
        PacketSlotClick packet = new PacketSlotClick(PacketId.CHIPSET_CLICK, (TileEntity)this.tile, slot);
        Proxies.net.sendToServer(packet);
    }

    @Override
    public void handleChipsetClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        if (((ISocketable)this.tile).getSocket(slot) != null) {
            return;
        }
        if (!ChipsetManager.circuitRegistry.isChipset(itemstack)) {
            return;
        }
        ICircuitBoard circuitBoard = ChipsetManager.circuitRegistry.getCircuitboard(itemstack);
        if (circuitBoard == null) {
            return;
        }
        try {
            if (!((ISocketable)this.tile).getSocketType().equals(circuitBoard.getSocketType())) {
                return;
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        ItemStack toSocket = itemstack.copy();
        toSocket.stackSize = 1;
        ((ISocketable)this.tile).setSocket(slot, toSocket);
        ItemStack stack = player.inventory.getItemStack();
        --stack.stackSize;
        if (stack.stackSize <= 0) {
            player.inventory.setItemStack(null);
        }
        player.updateHeldItem();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
    }

    @Override
    public void handleSolderingIronClick(int slot) {
        PacketSlotClick packet = new PacketSlotClick(PacketId.SOLDERING_IRON_CLICK, (TileEntity)this.tile, slot);
        Proxies.net.sendToServer(packet);
    }

    @Override
    public void handleSolderingIronClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        ItemStack socket = ((ISocketable)this.tile).getSocket(slot);
        if (socket == null) {
            return;
        }
        InventoryUtil.stowInInventory(socket, (IInventory)player.inventory, true);
        if (socket.stackSize > 0) {
            return;
        }
        ((ISocketable)this.tile).setSocket(slot, null);
        itemstack.damageItem(1, (EntityLivingBase)player);
        if (itemstack.stackSize <= 0) {
            player.inventory.setItemStack(null);
        }
        player.updateHeldItem();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
    }
}

