/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.tiles.TileUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockWood
extends Block
implements ITileEntityProvider,
IWoodTyped {
    private final String blockKind;
    private final boolean fireproof;

    protected BlockWood(String blockKind, boolean fireproof) {
        super(Material.wood);
        this.blockKind = blockKind;
        this.fireproof = fireproof;
        this.setStepSound(soundTypeWood);
        this.setCreativeTab(Tabs.tabArboriculture);
    }

    @Override
    public final String getBlockKind() {
        return this.blockKind;
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    public static TileWood getWoodTile(IBlockAccess world, int x, int y, int z) {
        return TileUtil.getTile(world, x, y, z, TileWood.class);
    }

    protected static NBTTagCompound getTagCompound(IBlockAccess world, int x, int y, int z) {
        TileWood wood = BlockWood.getWoodTile(world, x, y, z);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (wood == null) {
            return nbttagcompound;
        }
        EnumWoodType woodType = wood.getWoodType();
        woodType.saveToCompound(nbttagcompound);
        return nbttagcompound;
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerBlockIcons(IIconRegister register) {
        IconProviderWood.registerIcons(register);
    }

    public final TileEntity createNewTileEntity(World world, int meta) {
        return new TileWood();
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = new ItemStack((Block)this);
        NBTTagCompound nbt = BlockWood.getTagCompound((IBlockAccess)world, x, y, z);
        itemStack.setTagCompound(nbt);
        return itemStack;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return TileWood.blockRemovedByPlayer(this, world, player, x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        world.removeTileEntity(x, y, z);
        super.breakBlock(world, x, y, z, block, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public final float getBlockHardness(World world, int x, int y, int z) {
        TileWood wood = BlockWood.getWoodTile((IBlockAccess)world, x, y, z);
        if (wood == null) {
            return 2.0f;
        }
        return wood.getWoodType().getHardness();
    }

    public final boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return !this.isFireproof();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 5;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIcon getIcon(IBlockAccess var1, int var2, int var3, int var4, int var5);
}

