/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.core.render.TextureManager;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFruitPod
extends BlockCocoa {
    @SideOnly(value=Side.CLIENT)
    private static IIcon defaultIcon;

    public static TileFruitPod getPodTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileFruitPod)) {
            return null;
        }
        return (TileFruitPod)tile;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            world.setBlockToAir(x, y, z);
            return;
        }
        TileFruitPod tile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return;
        }
        tile.onBlockTick();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileFruitPod tile;
        if (!world.isRemote && (tile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z)) != null) {
            for (ItemStack drop : tile.getDrop()) {
                ItemStackUtil.dropItemStackAsEntity(drop, world, x, y, z);
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return BlockUtil.getDirectionalMetadata(world, x, y, z) >= 0;
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        world.removeTileEntity(x, y, z);
        super.breakBlock(world, x, y, z, block, meta);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileFruitPod();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        defaultIcon = TextureManager.getInstance().registerTex(register, "pods/papaya.2");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        IIcon podIcon;
        TileFruitPod pod = BlockFruitPod.getPodTile(world, x, y, z);
        if (pod != null && (podIcon = pod.getIcon()) != null) {
            return podIcon;
        }
        return defaultIcon;
    }

    public int getRenderType() {
        return PluginArboriculture.modelIdPods;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        TileFruitPod podTile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (podTile != null) {
            return podTile.canMature();
        }
        return false;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        TileFruitPod podTile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (podTile != null) {
            podTile.mature();
        }
    }
}

