/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.core.IToolScoop;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.core.utils.ItemStackUtil;
import forestry.lepidopterology.entities.AIButterflyFlee;
import forestry.lepidopterology.entities.AIButterflyMate;
import forestry.lepidopterology.entities.AIButterflyPollinate;
import forestry.lepidopterology.entities.AIButterflyRest;
import forestry.lepidopterology.entities.AIButterflyRise;
import forestry.lepidopterology.entities.AIButterflyWander;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.render.RenderButterflyItem;
import forestry.plugins.PluginLepidopterology;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;

public class EntityButterfly
extends EntityCreature
implements IEntityButterfly {
    public static final int COOLDOWNS = 1500;
    private static final int DATAWATCHER_ID_SPECIES = 16;
    private static final int DATAWATCHER_ID_SCALE = 17;
    private static final int DATAWATCHER_ID_STATE = 18;
    public static final float DEFAULT_BUTTERFLY_SCALE = 0.75f;
    private static final EnumButterflyState DEFAULT_STATE = EnumButterflyState.FLYING;
    public static final int EXHAUSTION_REST = 1000;
    public static final int EXHAUSTION_CONSUMPTION = 100000;
    private ChunkCoordinates flightTarget;
    private int exhaustion;
    private IAlleleButterflySpecies species;
    private IButterfly contained;
    private IIndividual pollen;
    private EnumButterflyState state = DEFAULT_STATE;
    private float scale = 0.75f;
    private String mothTexture;
    private long lastUpdate;
    public int cooldownPollination = 0;
    public int cooldownEgg = 0;
    private int lifespanRemaining = 168000;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation textureResource;
    private long lastTextureUpdate;

    public EntityButterfly(World world) {
        super(world);
        this.setDefaults(PluginLepidopterology.butterflyInterface.templateAsIndividual(PluginLepidopterology.butterflyInterface.getRandomTemplate(this.rand)));
    }

    public EntityButterfly(World world, IButterfly butterfly) {
        super(world);
        this.setDefaults(butterfly);
    }

    private void setDefaults(IButterfly butterfly) {
        this.contained = butterfly;
        this.tasks.addTask(8, (EntityAIBase)new AIButterflyFlee(this));
        this.tasks.addTask(9, (EntityAIBase)new AIButterflyMate(this));
        this.tasks.addTask(10, (EntityAIBase)new AIButterflyPollinate(this));
        this.tasks.addTask(11, (EntityAIBase)new AIButterflyRest(this));
        this.tasks.addTask(12, (EntityAIBase)new AIButterflyRise(this));
        this.tasks.addTask(12, (EntityAIBase)new AIButterflyWander(this));
    }

    @Override
    public EntityCreature getEntity() {
        return this;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        NBTTagCompound bio = new NBTTagCompound();
        this.contained.writeToNBT(bio);
        nbttagcompound.setTag("BTFLY", (NBTBase)bio);
        if (this.pollen != null) {
            NBTTagCompound pln = new NBTTagCompound();
            this.pollen.writeToNBT(pln);
            nbttagcompound.setTag("PLN", (NBTBase)pln);
        }
        nbttagcompound.setByte("STATE", (byte)this.state.ordinal());
        nbttagcompound.setInteger("EXH", this.exhaustion);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("BTFLY")) {
            this.contained = new Butterfly((NBTTagCompound)nbttagcompound.getTag("BTFLY"));
        }
        this.setIndividual(this.contained);
        if (nbttagcompound.hasKey("PLN")) {
            this.pollen = AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees").getMember((NBTTagCompound)nbttagcompound.getTag("PLN"));
        }
        this.state = EnumButterflyState.VALUES[nbttagcompound.getByte("STATE")];
        this.exhaustion = nbttagcompound.getInteger("EXH");
    }

    public float getWingFlap(float partialTicktime) {
        return this.state.getWingFlap(this, partialTicktime);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float size) {
        this.scale = size;
    }

    public float getSpeed() {
        return this.contained.getGenome().getSpeed();
    }

    public ChunkCoordinates getDestination() {
        return this.flightTarget;
    }

    public void setDestination(ChunkCoordinates destination) {
        this.flightTarget = destination;
    }

    public float getBlockPathWeight(int x, int y, int z) {
        int depth;
        float weight = 0.0f;
        if (!this.getButterfly().isAcceptedEnvironment(this.worldObj, x, y, z)) {
            weight -= 15.0f;
        }
        if (!this.worldObj.getEntitiesWithinAABB(EntityButterfly.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1))).isEmpty()) {
            weight -= 1.0f;
        }
        if ((depth = this.getFluidDepth(x, z)) > 0) {
            weight -= 0.1f * (float)depth;
        } else {
            Block block = this.worldObj.getBlock(x, y, z);
            if (block instanceof BlockFlower) {
                weight += 2.0f;
            } else if (block instanceof IPlantable) {
                weight += 1.5f;
            } else if (block instanceof IGrowable) {
                weight += 1.0f;
            } else if (block.getMaterial() == Material.plants) {
                weight += 1.0f;
            }
            block = this.worldObj.getBlock(x, y - 1, z);
            if (block.isLeaves((IBlockAccess)this.worldObj, x, y - 1, z)) {
                weight += 2.5f;
            } else if (block instanceof BlockFence) {
                weight += 1.0f;
            } else if (block instanceof BlockWall) {
                weight += 1.0f;
            }
        }
        return weight += this.worldObj.getLightBrightness(x, y, z);
    }

    private int getFluidDepth(int x, int z) {
        Chunk chunk = this.worldObj.getChunkFromBlockCoords(x, z);
        int xx = x & 0xF;
        int zz = z & 0xF;
        int depth = 0;
        for (int y = chunk.getTopFilledSegment() + 15; y > 0; --y) {
            Block block = chunk.getBlock(xx, y, zz);
            if (block.getMaterial().isLiquid()) {
                ++depth;
                continue;
            }
            if (!block.isAir((IBlockAccess)this.worldObj, x, y, z)) break;
        }
        return depth;
    }

    @Override
    public IIndividual getPollen() {
        return this.pollen;
    }

    @Override
    public void setPollen(IIndividual pollen) {
        this.pollen = pollen;
    }

    public EnumButterflyState getState() {
        return this.state;
    }

    public void setState(EnumButterflyState state) {
        if (state != this.state) {
            this.state = state;
            this.dataWatcher.updateObject(18, (Object)((byte)state.ordinal()));
        }
    }

    public boolean isRenderable() {
        return this.species != null;
    }

    @Override
    public void changeExhaustion(int change) {
        this.exhaustion = this.exhaustion + change > 0 ? this.exhaustion + change : 0;
    }

    @Override
    public int getExhaustion() {
        return this.exhaustion;
    }

    public boolean canFly() {
        return this.contained.canTakeFlight(this.worldObj, this.posX, this.posY, this.posZ);
    }

    private void resetAppearance() {
        this.mothTexture = this.species.getEntityTexture();
        this.setSize(this.getScale(), 0.2f);
    }

    private EntityButterfly setIndividual(IButterfly butterfly) {
        this.contained = butterfly != null ? butterfly : PluginLepidopterology.butterflyInterface.templateAsIndividual(PluginLepidopterology.butterflyInterface.getDefaultTemplate());
        this.isImmuneToFire = this.contained.getGenome().getFireResist();
        this.setSpecies(this.contained.getGenome().getPrimary());
        this.dataWatcher.updateObject(16, (Object)this.species.getUID());
        this.dataWatcher.updateObject(17, (Object)((int)(this.contained.getSize() * 100.0f)));
        return this;
    }

    @Override
    public IButterfly getButterfly() {
        return this.contained;
    }

    public EntityButterfly setSpecies(IAlleleButterflySpecies butterfly) {
        this.species = butterfly;
        this.resetAppearance();
        this.lastUpdate = this.worldObj.getTotalWorldTime();
        return this;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        if (!this.worldObj.isRemote) {
            this.setIndividual(this.contained);
        }
        return data;
    }

    public boolean getCanSpawnHere() {
        return true;
    }

    protected void entityInit() {
        super.entityInit();
        if (this.state == null) {
            this.state = DEFAULT_STATE;
        }
        this.dataWatcher.addObject(16, (Object)"");
        this.dataWatcher.addObject(17, (Object)75);
        this.dataWatcher.addObject(18, (Object)((byte)this.state.ordinal()));
    }

    public int getMaxInPortalTime() {
        return 1000;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        if (this.textureResource == null || this.lastTextureUpdate != this.lastUpdate) {
            this.textureResource = new ResourceLocation(this.mothTexture);
        }
        return this.textureResource;
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity other) {
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean interact(EntityPlayer player) {
        if (this.isDead) {
            return false;
        }
        if (player.getHeldItem() == null) {
            return false;
        }
        if (!(player.getHeldItem().getItem() instanceof IToolScoop)) {
            return false;
        }
        if (!this.worldObj.isRemote) {
            this.contained.getGenome().getPrimary().getRoot().getBreedingTracker(this.worldObj, player.getGameProfile()).registerCatch(this.contained);
            ItemStackUtil.dropItemStackAsEntity(PluginLepidopterology.butterflyInterface.getMemberStack(this.contained.copy(), EnumFlutterType.BUTTERFLY.ordinal()), this.worldObj, this.posX, this.posY, this.posZ);
            this.setDead();
        } else {
            player.swingItem();
        }
        return true;
    }

    protected void dropFewItems(boolean playerKill, int lootLevel) {
        for (ItemStack stack : this.contained.getLootDrop(this, playerKill, lootLevel)) {
            ItemStackUtil.dropItemStackAsEntity(stack, this.worldObj, this.posX, this.posY, this.posZ);
        }
        if (this.getPollen() != null) {
            ItemStackUtil.dropItemStackAsEntity(AlleleManager.alleleRegistry.getSpeciesRoot(this.getPollen().getClass()).getMemberStack(this.getPollen(), EnumGermlingType.POLLEN.ordinal()), this.worldObj, this.posX, this.posY, this.posZ);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote) {
            if (this.species == null || this.dataWatcher.hasChanges()) {
                IAllele allele;
                this.scale = (float)this.dataWatcher.getWatchableObjectInt(17) / 100.0f;
                String uid = this.dataWatcher.getWatchableObjectString(16);
                if ((this.species == null || !this.species.getUID().equals(uid)) && (allele = AlleleManager.alleleRegistry.getAllele(uid)) instanceof IAlleleButterflySpecies) {
                    this.setSpecies((IAlleleButterflySpecies)allele);
                }
            }
            this.state = EnumButterflyState.VALUES[this.dataWatcher.getWatchableObjectByte(18)];
        }
        this.motionY *= (double)0.6f;
        if (this.exhaustion > 100000 && this.getRNG().nextInt(20) == 0) {
            this.attackEntityFrom(DamageSource.generic, 1.0f);
        }
        if (this.lifespanRemaining > 0) {
            --this.lifespanRemaining;
        } else {
            this.attackEntityFrom(DamageSource.generic, 1.0f);
        }
        if (this.cooldownEgg > 0) {
            --this.cooldownEgg;
        }
        if (this.cooldownPollination > 0) {
            --this.cooldownPollination;
        }
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.state.doesMovement && this.flightTarget != null) {
            double diffX = (double)this.flightTarget.posX + 0.5 - this.posX;
            double diffY = (double)this.flightTarget.posY + 0.1 - this.posY;
            double diffZ = (double)this.flightTarget.posZ + 0.5 - this.posZ;
            this.motionX += (Math.signum(diffX) * 0.5 - this.motionX) * (double)0.1f;
            this.motionY += (Math.signum(diffY) * (double)0.7f - this.motionY) * (double)0.1f;
            this.motionZ += (Math.signum(diffZ) * 0.5 - this.motionZ) * (double)0.1f;
            float horizontal = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) - 90.0f;
            this.rotationYaw += MathHelper.wrapAngleTo180_float((float)(horizontal - this.rotationYaw));
            this.setMoveForward(this.contained.getGenome().getSpeed());
        }
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return true;
    }

    public float getSwingProgress(float partialTicktime) {
        float flap = this.swingProgress - this.prevSwingProgress;
        if (flap < 0.0f) {
            flap += 1.0f;
        }
        return this.prevSwingProgress + flap * partialTicktime;
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public static enum EnumButterflyState {
        FLYING(true),
        GLIDING(true),
        RISING(true),
        RESTING(false),
        HOVER(false);

        public static final EnumButterflyState[] VALUES;
        public final boolean doesMovement;

        private EnumButterflyState(boolean doesMovement) {
            this.doesMovement = doesMovement;
        }

        public float getWingFlap(EntityButterfly entity, float partialTicktime) {
            if (this == RESTING || this == HOVER) {
                long systemTime = System.currentTimeMillis();
                long flapping = systemTime + (long)entity.contained.getIdent().hashCode();
                float flap = (float)(flapping % 1000L) / 1000.0f;
                return RenderButterflyItem.getIrregularWingYaw(flapping, flap);
            }
            return (float)entity.ticksExisted + partialTicktime;
        }

        static {
            VALUES = EnumButterflyState.values();
        }
    }
}

