/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableGourd
implements IFarmable {
    private final ItemStack seed;
    private final ItemStack stem;
    private final ItemStack fruit;

    public FarmableGourd(ItemStack seed, ItemStack stem, ItemStack fruit) {
        this.seed = seed;
        this.stem = stem;
        this.fruit = fruit;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.isAirBlock(x, y, z)) {
            return false;
        }
        return ItemStackUtil.equals(world.getBlock(x, y, z), this.stem);
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.isAirBlock(x, y, z)) {
            return null;
        }
        if (!ItemStackUtil.equals(world.getBlock(x, y, z), this.fruit)) {
            return null;
        }
        if (world.getBlockMetadata(x, y, z) != this.fruit.getItemDamage()) {
            return null;
        }
        return new CropBlock(world, ItemStackUtil.getBlock(this.fruit), this.fruit.getItemDamage(), new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return this.seed.isItemEqual(itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return world.setBlock(x, y, z, ItemStackUtil.getBlock(this.stem), 0, 2);
    }
}

