/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockWood;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSlab
extends net.minecraft.block.BlockSlab
implements IWoodTyped,
ITileEntityProvider {
    private final boolean fireproof;

    public BlockSlab(boolean fireproof) {
        super(false, Material.wood);
        this.fireproof = fireproof;
        this.setCreativeTab(Tabs.tabArboriculture);
        this.setLightOpacity(0);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setStepSound(soundTypeWood);
        this.setHarvestLevel("axe", 0);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        IconProviderWood.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return IconProviderWood.getPlankIcon(EnumWoodType.LARCH);
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileWood wood = BlockWood.getWoodTile(world, x, y, z);
        EnumWoodType woodType = wood.getWoodType();
        return IconProviderWood.getPlankIcon(woodType);
    }

    public Item getItemDropped(int meta, Random random, int par3) {
        return Item.getItemFromBlock((Block)this);
    }

    protected ItemStack createStackedBlock(int meta) {
        return new ItemStack((Block)Blocks.wooden_slab, 2, meta & 7);
    }

    public String func_150002_b(int var1) {
        return "SomeSlab";
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List list) {
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            list.add(TreeManager.woodItemAccess.getSlab(woodType, this.fireproof));
        }
    }

    public final TileEntity createNewTileEntity(World world, int meta) {
        return new TileWood();
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = new ItemStack((Block)this);
        NBTTagCompound nbt = BlockWood.getTagCompound((IBlockAccess)world, x, y, z);
        itemStack.setTagCompound(nbt);
        return itemStack;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return TileWood.blockRemovedByPlayer(this, world, player, x, y, z);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        world.removeTileEntity(x, y, z);
        super.breakBlock(world, x, y, z, block, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public final float getBlockHardness(World world, int x, int y, int z) {
        TileWood wood = BlockWood.getWoodTile((IBlockAccess)world, x, y, z);
        if (wood == null) {
            return 2.0f;
        }
        return wood.getWoodType().getHardness();
    }

    public final boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return !this.isFireproof();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 5;
    }

    @Override
    public String getBlockKind() {
        return "slab";
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    public boolean getUseNeighborBrightness() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World world, int x, int y, int z) {
        return Item.getItemFromBlock((Block)this);
    }
}

