/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.nei;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.core.recipes.nei.CustomOverlayHandler;
import forestry.core.recipes.nei.IRecipeHandlerBase;
import forestry.core.recipes.nei.ItemFilterGenetic;
import forestry.core.recipes.nei.ItemFilterOther;
import forestry.core.recipes.nei.NEIHandlerShapedCustom;
import forestry.core.recipes.nei.NEIHandlerShapelessCustom;
import forestry.core.utils.Log;
import forestry.factory.gui.GuiWorktable;
import forestry.factory.recipes.nei.NEIHandlerBottler;
import forestry.factory.recipes.nei.NEIHandlerCarpenter;
import forestry.factory.recipes.nei.NEIHandlerCentrifuge;
import forestry.factory.recipes.nei.NEIHandlerFabricator;
import forestry.factory.recipes.nei.NEIHandlerFermenter;
import forestry.factory.recipes.nei.NEIHandlerMoistener;
import forestry.factory.recipes.nei.NEIHandlerSqueezer;
import forestry.factory.recipes.nei.NEIHandlerStill;
import forestry.plugins.PluginLepidopterology;
import net.minecraftforge.oredict.OreDictionary;

public class NEIIntegrationConfig
implements IConfigureNEI {
    public void loadConfig() {
        Log.info("Loading: " + this.getName());
        NEIIntegrationConfig.registerHandler(new NEIHandlerShapedCustom());
        NEIIntegrationConfig.registerHandler(new NEIHandlerShapelessCustom());
        NEIIntegrationConfig.registerHandler(new NEIHandlerBottler());
        NEIIntegrationConfig.registerHandler(new NEIHandlerCarpenter());
        NEIIntegrationConfig.registerHandler(new NEIHandlerCentrifuge());
        NEIIntegrationConfig.registerHandler(new NEIHandlerFabricator());
        NEIIntegrationConfig.registerHandler(new NEIHandlerFermenter());
        NEIIntegrationConfig.registerHandler(new NEIHandlerMoistener());
        NEIIntegrationConfig.registerHandler(new NEIHandlerSqueezer());
        NEIIntegrationConfig.registerHandler(new NEIHandlerStill());
        CustomOverlayHandler handler = new CustomOverlayHandler(-14, 14, true);
        API.registerGuiOverlayHandler(GuiWorktable.class, (IOverlayHandler)handler, (String)"crafting");
        API.addSubset((String)"Forestry.Bees.Princesses", (ItemFilter)new ItemFilterGenetic(BeeManager.beeRoot, EnumBeeType.PRINCESS.ordinal(), true));
        API.addSubset((String)"Forestry.Bees.Drones", (ItemFilter)new ItemFilterGenetic(BeeManager.beeRoot, EnumBeeType.DRONE.ordinal(), true));
        API.addSubset((String)"Forestry.Bees.Larvae", (ItemFilter)new ItemFilterGenetic(BeeManager.beeRoot, EnumBeeType.LARVAE.ordinal(), true));
        API.addSubset((String)"Forestry.Trees.Saplings", (ItemFilter)new ItemFilterGenetic(TreeManager.treeRoot, EnumGermlingType.SAPLING.ordinal(), true));
        API.addSubset((String)"Forestry.Trees.Pollen", (ItemFilter)new ItemFilterGenetic(TreeManager.treeRoot, EnumGermlingType.POLLEN.ordinal(), true));
        API.addSubset((String)"Forestry.Butterflies.Butterflies", (ItemFilter)new ItemFilterGenetic(PluginLepidopterology.butterflyInterface, EnumFlutterType.BUTTERFLY.ordinal(), true));
        API.addSubset((String)"Forestry.Butterflies.Caterpillars", (ItemFilter)new ItemFilterGenetic(PluginLepidopterology.butterflyInterface, EnumFlutterType.CATERPILLAR.ordinal(), true));
        API.addSubset((String)"Forestry.Butterflies.Serum", (ItemFilter)new ItemFilterGenetic(PluginLepidopterology.butterflyInterface, EnumFlutterType.SERUM.ordinal(), true));
        API.addSubset((String)"Forestry.Bees.Combs", (Iterable)OreDictionary.getOres((String)"beeComb"));
        API.addSubset((String)"Forestry.Blocks", (ItemFilter)new ItemFilterOther(false));
        API.addSubset((String)"Forestry.Items", (ItemFilter)new ItemFilterOther(true));
    }

    protected static void registerHandler(IRecipeHandlerBase handler) {
        handler.prepare();
        API.registerRecipeHandler((ICraftingHandler)handler);
        API.registerUsageHandler((IUsageHandler)handler);
    }

    public String getName() {
        return "Forestry NEI Integration";
    }

    public String getVersion() {
        return "1.1.0";
    }
}

