/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.config.ForestryItem;
import forestry.core.config.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.Log;
import forestry.farming.logic.FarmableBasicFruit;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.farming.logic.FarmableGenericSapling;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="BiomesOPlenty", name="BiomesOPlenty", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.biomesoplenty.description")
public class PluginBiomesOPlenty
extends ForestryPlugin {
    private static final String BoP = "BiomesOPlenty";
    private static Block saplings;
    private static Block colorizedSaplings;
    private static Item food;
    private static ItemStack persimmon;

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(BoP);
    }

    @Override
    public String getFailMessage() {
        return "BiomesOPlenty not found";
    }

    @Override
    public void doInit() {
        super.doInit();
        saplings = GameRegistry.findBlock((String)BoP, (String)"saplings");
        colorizedSaplings = GameRegistry.findBlock((String)BoP, (String)"colorizedSaplings");
        food = GameRegistry.findItem((String)BoP, (String)"food");
        if (food != null) {
            persimmon = new ItemStack(food, 1, 8);
        }
        PluginBiomesOPlenty.addFlowers();
        PluginBiomesOPlenty.addFarmCrops();
        PluginBiomesOPlenty.addFermenterRecipes();
        PluginBiomesOPlenty.addSqueezerRecipes();
    }

    private static void addFarmCrops() {
        Block boPTurnip;
        ArrayList<String> saplingItemKeys = new ArrayList<String>();
        if (saplings != null) {
            saplingItemKeys.add("saplings");
        }
        if (colorizedSaplings != null) {
            saplingItemKeys.add("colorizedSaplings");
        }
        for (String key : saplingItemKeys) {
            Item saplingItem = GameRegistry.findItem((String)BoP, (String)key);
            String saplingName = GameData.getItemRegistry().getNameForObject((Object)saplingItem);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        }
        if (saplings != null && persimmon != null) {
            Farmables.farmables.get("farmArboreal").add(new FarmableGenericSapling(saplings, 15, persimmon));
        }
        if ((boPTurnip = GameRegistry.findBlock((String)BoP, (String)"turnip")) != null) {
            Item boPTurnipSeeds = GameRegistry.findItem((String)BoP, (String)"turnipSeeds");
            if (boPTurnipSeeds != null) {
                Farmables.farmables.get("farmVegetables").add(new FarmableGenericCrop(new ItemStack(boPTurnipSeeds, 1, 0), boPTurnip, 7, new ItemStack[0]));
            }
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(boPTurnip, 7));
        }
    }

    private static void addFermenterRecipes() {
        int saplingYield = GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling");
        if (saplings != null) {
            RecipeUtil.addFermenterRecipes(new ItemStack(saplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
        if (colorizedSaplings != null) {
            RecipeUtil.addFermenterRecipes(new ItemStack(colorizedSaplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
    }

    private static void addSqueezerRecipes() {
        if (food != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(food)}, Fluids.JUICE.getFluid(50), ForestryItem.mulch.getItemStack(), 5);
        }
        if (persimmon != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{persimmon}, Fluids.JUICE.getFluid(200), ForestryItem.mulch.getItemStack(), 20);
        }
    }

    private static void addFlowers() {
        Block plants;
        Block mushrooms;
        Block flowers2;
        Block flowers = GameRegistry.findBlock((String)BoP, (String)"flowers");
        if (flowers != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 0, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 1, 1.0, "flowersVanilla", "flowersMushrooms");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 3, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 4, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 5, 1.0, "flowersVanilla", "flowersJungle");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 6, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 7, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 8, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 9, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 10, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 11, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 12, 1.0, "flowersCacti");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 13, 1.0, "flowersNether");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 15, 1.0, "flowersVanilla");
        }
        if ((flowers2 = GameRegistry.findBlock((String)BoP, (String)"flowers2")) != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 0, 1.0, "flowersVanilla", "flowersJungle");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 1, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 2, 1.0, "flowersNether");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 3, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 4, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 5, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 6, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 7, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 8, 1.0, "flowersVanilla");
        }
        if ((mushrooms = GameRegistry.findBlock((String)BoP, (String)"mushrooms")) != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(mushrooms, Short.MAX_VALUE, 1.0, "flowersMushrooms");
            FlowerManager.flowerRegistry.registerPlantableFlower(mushrooms, 3, 1.0, "flowersNether");
        }
        if ((plants = GameRegistry.findBlock((String)BoP, (String)"plants")) != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(plants, 12, 1.0, "flowersCacti");
        }
    }

    @Override
    protected void registerBackpackItems() {
        boolean MINER = false;
        boolean DIGGER = true;
        int FORESTER = 2;
        PluginBiomesOPlenty.addBlocksToBackpack(0, "driedDirt", "overgrownNetherrack", "cragRock", "ashStone");
        PluginBiomesOPlenty.addBlocksToBackpack(1, "bopGrass", "newBopGrass", "longGrass", "mud", "hardDirt", "hardSand", "originGrass", "ash", "newBopDirt");
        PluginBiomesOPlenty.addBlocksToBackpack(2, "petals");
    }

    private static void addBlocksToBackpack(int backpackId, String ... blockNames) {
        for (String blockName : blockNames) {
            Block block = GameRegistry.findBlock((String)BoP, (String)blockName);
            if (block != null) {
                ItemStack blockStack = new ItemStack(block, 1, Short.MAX_VALUE);
                BackpackManager.backpackItems[backpackId].add(blockStack);
                continue;
            }
            Log.warning("Missing block: ", (Object)blockName);
        }
    }
}

