/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.blocks.IItemTyped;
import forestry.farming.worldgen.WorldGenBigMushroom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BlockMushroom
extends BlockSapling
implements IItemTyped {
    private final WorldGenerator[] generators;
    private final ItemStack[] drops;

    public BlockMushroom() {
        this.setHardness(0.0f);
        this.generators = new WorldGenerator[]{new WorldGenBigMushroom(Blocks.brown_mushroom_block), new WorldGenBigMushroom(Blocks.red_mushroom_block)};
        this.drops = new ItemStack[]{new ItemStack((Block)Blocks.brown_mushroom), new ItemStack((Block)Blocks.red_mushroom)};
        this.setCreativeTab(null);
        this.setTickRandomly(true);
    }

    public boolean getTickRandomly() {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int X, int Y, int Z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        MushroomType type = this.getTypeFromMeta(metadata);
        ret.add(this.drops[type.ordinal()]);
        return ret;
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == Blocks.mycelium;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.isRemote) {
            return;
        }
        int meta = world.getBlockMetadata(i, j, k);
        MushroomType type = this.getTypeFromMeta(meta);
        int maturity = meta >> 2;
        this.tickGermling(world, i, j, k, random, type, maturity);
    }

    private void tickGermling(World world, int i, int j, int k, Random random, MushroomType type, int maturity) {
        int lightvalue = world.getBlockLightValue(i, j + 1, k);
        if (random.nextInt(2) != 0) {
            return;
        }
        if (maturity != 3) {
            maturity = 3;
            int matX = maturity << 2;
            int meta = matX | type.ordinal();
            world.setBlockMetadataWithNotify(i, j, k, meta, 2);
        } else if (lightvalue <= 7) {
            this.func_149878_d(world, i, j, k, random);
        }
    }

    public void func_149878_d(World world, int i, int j, int k, Random random) {
        MushroomType type = this.getTypeFromMeta(world.getBlockMetadata(i, j, k));
        world.setBlockToAir(i, j, k);
        if (!this.generators[type.ordinal()].generate(world, random, i, j, k)) {
            world.setBlock(i, j, k, (Block)this, type.ordinal(), 0);
        }
    }

    @Override
    public MushroomType getTypeFromMeta(int meta) {
        return MushroomType.values()[meta %= MushroomType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        MushroomType type = this.getTypeFromMeta(meta);
        switch (type) {
            case BROWN: {
                return Blocks.brown_mushroom.getIcon(side, meta);
            }
            case RED: {
                return Blocks.red_mushroom.getIcon(side, meta);
            }
        }
        return null;
    }

    public static enum MushroomType {
        BROWN,
        RED;

    }
}

