/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.core.fluids.FluidHelper;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.PositionedStackAdv;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiSqueezer;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.ISqueezerRecipe;
import forestry.factory.tiles.TileSqueezer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerSqueezer
extends RecipeHandlerBase {
    private static final int[][] INPUTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    @Override
    public String getRecipeID() {
        return "forestry.squeezer";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory.5.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/squeezersocket.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(72, 29, 41, 18);
    }

    public void drawExtras(int recipeIndex) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (recipe instanceof CachedSqueezerRecipe) {
            int processingTime = ((CachedSqueezerRecipe)recipe).processingTime;
            this.drawProgressBar(70, 30, 176, 60, 43, 18, processingTime * 5, 0);
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSqueezer.class;
    }

    @Override
    public void loadAllRecipes() {
        for (ISqueezerRecipe recipe : TileSqueezer.RecipeManager.recipes) {
            this.arecipes.add(new CachedSqueezerRecipe(recipe, true));
        }
        for (ISqueezerContainerRecipe containerRecipe : TileSqueezer.RecipeManager.containerRecipes.values()) {
            this.arecipes.add(new CachedSqueezerRecipe(containerRecipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (ISqueezerRecipe recipe : TileSqueezer.RecipeManager.recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getRemnants(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(recipe, true));
        }
        for (ISqueezerContainerRecipe containerRecipe : TileSqueezer.RecipeManager.containerRecipes.values()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)containerRecipe.getRemnants(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(containerRecipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (ISqueezerRecipe recipe : TileSqueezer.RecipeManager.recipes) {
            if (!NEIUtils.areFluidsSameType(recipe.getFluidOutput(), result)) continue;
            this.arecipes.add(new CachedSqueezerRecipe(recipe, true));
        }
        for (ISqueezerContainerRecipe containerRecipe : TileSqueezer.RecipeManager.containerRecipes.values()) {
            ISqueezerRecipe recipe;
            ItemStack emptyContainer = containerRecipe.getEmptyContainer();
            ItemStack filledContainer = FluidHelper.getFilledContainer(result, emptyContainer);
            if (filledContainer == null || (recipe = containerRecipe.getSqueezerRecipe(filledContainer)) == null) continue;
            this.arecipes.add(new CachedSqueezerRecipe(recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        ingred.stackSize = 1;
        ISqueezerContainerRecipe containerRecipe = TileSqueezer.RecipeManager.findMatchingContainerRecipe(ingred);
        if (containerRecipe != null) {
            CachedSqueezerRecipe crecipe = new CachedSqueezerRecipe(containerRecipe, true);
            crecipe.setIngredients(new ItemStack[]{ingred});
            FluidStack fluidStack = FluidHelper.getFluidStackInContainer(ingred);
            crecipe.setTankFluid(fluidStack);
            this.arecipes.add(crecipe);
            return;
        }
        ISqueezerRecipe recipe = TileSqueezer.RecipeManager.findMatchingRecipe(new ItemStack[]{ingred});
        if (recipe != null) {
            CachedSqueezerRecipe crecipe = new CachedSqueezerRecipe(recipe);
            crecipe.setIngredients(new ItemStack[]{ingred});
            this.arecipes.add(crecipe);
        }
    }

    public class CachedSqueezerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedFluidTank tank;
        public PositionedStackAdv remnants = null;
        public int processingTime;
        public boolean containerRecipe = false;

        public CachedSqueezerRecipe(ISqueezerRecipe recipe, boolean genPerms) {
            if (recipe.getResources() != null) {
                this.setIngredients(recipe.getResources());
            }
            if (recipe.getFluidOutput() != null) {
                this.setTankFluid(recipe.getFluidOutput());
            }
            if (recipe.getRemnants() != null) {
                this.remnants = new PositionedStackAdv(recipe.getRemnants(), 92, 49).setChance(recipe.getRemnantsChance());
            }
            this.processingTime = recipe.getProcessingTime();
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedSqueezerRecipe(ISqueezerRecipe recipe) {
            this(recipe, false);
        }

        public CachedSqueezerRecipe(ISqueezerContainerRecipe recipe, boolean genPerms) {
            this.containerRecipe = true;
            ItemStack emptyContainer = recipe.getEmptyContainer();
            List<ItemStack> ingredients = FluidHelper.getAllFilledContainers(emptyContainer);
            this.setIngredients(new Object[]{ingredients});
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (ItemStack ingredient : ingredients) {
                FluidStack fluidStack = FluidHelper.getFluidStackInContainer(ingredient);
                fluids.add(fluidStack);
            }
            this.setTankFluid(fluids);
            if (recipe.getRemnants() != null) {
                this.remnants = new PositionedStackAdv(recipe.getRemnants(), 92, 49).setChance(recipe.getRemnantsChance());
            }
            this.processingTime = recipe.getProcessingTime();
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public void setIngredients(Object[] inputs) {
            this.inputs.clear();
            int i = 0;
            for (Object stack : inputs) {
                if (i >= INPUTS.length) {
                    return;
                }
                this.inputs.add(new PositionedStack(stack, 12 + INPUTS[i][0] * 18, 10 + INPUTS[i][1] * 18, false));
                ++i;
            }
        }

        public void setTankFluid(FluidStack ... fluidStack) {
            this.setTankFluid(Arrays.asList(fluidStack));
        }

        public void setTankFluid(Collection<FluidStack> fluidStacks) {
            this.tank = new PositionedFluidTank(fluidStacks, 10000, new Rectangle(117, 7, 16, 58), NEIHandlerSqueezer.this.getGuiTexture(), new Point(176, 0));
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerSqueezer.this.cycleticks / 20, this.inputs);
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            if (this.containerRecipe) {
                Random random = new Random(cycle);
                cycle = Math.abs(random.nextInt());
                for (PositionedStack ingredient : ingredients) {
                    ingredient.setPermutationToRender(cycle % ingredient.items.length);
                }
                this.tank.setPermutationToRender(cycle % this.tank.getPermutationCount());
                return ingredients;
            }
            return super.getCycledIngredients(cycle, ingredients);
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }

        public PositionedStack getResult() {
            return this.remnants;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

