/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.errors.ErrorLogic;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.IRestrictedAccessTile;
import forestry.core.tiles.ITitled;
import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.statements.ITriggerProvider", modid="BuildCraftAPI|statements")
public abstract class TileForestry
extends TileEntity
implements IStreamable,
IErrorLogicSource,
ITriggerProvider,
ISidedInventory,
IFilterSlotDelegate,
IRestrictedAccessTile,
ITitled {
    private static final Random rand = new Random();
    private final AccessHandler accessHandler = new AccessHandler(this);
    private final ErrorLogic errorHandler = new ErrorLogic();
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    private IInventoryAdapter inventory = FakeInventoryAdapter.instance();
    private int tickCount = rand.nextInt(256);
    private boolean needsNetworkUpdate = false;
    private ForgeDirection orientation = ForgeDirection.WEST;

    protected AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void onNeighborBlockChange(Block id) {
        this.tileCache.onNeighborChange();
    }

    public void invalidate() {
        this.tileCache.purge();
        super.invalidate();
    }

    public void validate() {
        this.tileCache.purge();
        super.validate();
    }

    public void rotateAfterPlacement(EntityLivingBase entityLiving) {
        int l = MathHelper.floor_double((double)((double)(entityLiving.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.setOrientation(ForgeDirection.NORTH);
        }
        if (l == 1) {
            this.setOrientation(ForgeDirection.EAST);
        }
        if (l == 2) {
            this.setOrientation(ForgeDirection.SOUTH);
        }
        if (l == 3) {
            this.setOrientation(ForgeDirection.WEST);
        }
    }

    public final void updateEntity() {
        ++this.tickCount;
        if (!this.worldObj.isRemote) {
            this.updateServerSide();
        } else {
            this.updateClientSide();
        }
        if (this.needsNetworkUpdate) {
            this.needsNetworkUpdate = false;
            this.sendNetworkUpdate();
        }
    }

    protected void updateClientSide() {
    }

    protected void updateServerSide() {
    }

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.readFromNBT(data);
        this.accessHandler.readFromNBT(data);
        this.orientation = data.hasKey("Orientation") ? ForgeDirection.values()[data.getInteger("Orientation")] : ForgeDirection.WEST;
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inventory.writeToNBT(data);
        this.accessHandler.writeToNBT(data);
        data.setInteger("Orientation", this.orientation.ordinal());
    }

    public Packet getDescriptionPacket() {
        PacketTileStream packet = new PacketTileStream(this);
        return packet.getPacket();
    }

    protected final void sendNetworkUpdate() {
        PacketTileStream packet = new PacketTileStream(this);
        Proxies.net.sendNetworkPacket(packet, this.worldObj);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeByte(this.orientation.ordinal());
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.orientation = ForgeDirection.getOrientation((int)data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.accessHandler.writeData(data);
        this.errorHandler.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.accessHandler.readData(data);
        this.errorHandler.readData(data);
    }

    public void onRemoval() {
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        return null;
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        return null;
    }

    protected boolean isRedstoneActivated() {
        return this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord);
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        if (orientation == null) {
            throw new NullPointerException("Orientation cannot be null");
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.setNeedsNetworkUpdate();
    }

    protected final void setNeedsNetworkUpdate() {
        this.needsNetworkUpdate = true;
    }

    @Override
    public final IErrorLogic getErrorLogic() {
        return this.errorHandler;
    }

    @Override
    public final IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.blockType);
            this.markDirty();
        }
    }

    @Override
    public String getUnlocalizedTitle() {
        String blockUnlocalizedName = this.getBlockType().getUnlocalizedName().replace("tile.for.", "");
        return blockUnlocalizedName + '.' + this.getBlockMetadata() + ".name";
    }

    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    protected final void setInternalInventory(IInventoryAdapter inv) {
        if (inv == null) {
            throw new NullPointerException("Inventory cannot be null");
        }
        this.inventory = inv;
    }

    public final int getSizeInventory() {
        return this.getInternalInventory().getSizeInventory();
    }

    public final ItemStack getStackInSlot(int slotIndex) {
        return this.getInternalInventory().getStackInSlot(slotIndex);
    }

    public ItemStack decrStackSize(int slotIndex, int amount) {
        return this.getInternalInventory().decrStackSize(slotIndex, amount);
    }

    public final ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.getInternalInventory().getStackInSlotOnClosing(slotIndex);
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().setInventorySlotContents(slotIndex, itemstack);
    }

    public final int getInventoryStackLimit() {
        return this.getInternalInventory().getInventoryStackLimit();
    }

    public final void openInventory() {
        this.getInternalInventory().openInventory();
    }

    public final void closeInventory() {
        this.getInternalInventory().closeInventory();
    }

    public final String getInventoryName() {
        return this.getUnlocalizedTitle();
    }

    public final boolean isUseableByPlayer(EntityPlayer player) {
        return this.getInternalInventory().isUseableByPlayer(player);
    }

    public final boolean hasCustomInventoryName() {
        return this.getInternalInventory().hasCustomInventoryName();
    }

    public final boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().isItemValidForSlot(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public final int[] getAccessibleSlotsFromSide(int side) {
        return this.getInternalInventory().getAccessibleSlotsFromSide(side);
    }

    public final boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().canInsertItem(slotIndex, itemStack, side);
    }

    public final boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        return this.getInternalInventory().canExtractItem(slotIndex, itemStack, side);
    }

    @Override
    public final ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }
}

