/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.apiculture.network.PacketUpdateCandle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class TileCandle
extends TileEntity {
    private int colour;
    private boolean lit;

    public boolean canUpdate() {
        return false;
    }

    public Packet getDescriptionPacket() {
        PacketUpdateCandle updateCandle = new PacketUpdateCandle(this);
        return updateCandle.getPacket();
    }

    public void onPacketUpdate(PacketUpdateCandle updateCandle) {
        this.colour = updateCandle.getColour();
        this.lit = updateCandle.isLit();
    }

    public void readFromNBT(NBTTagCompound tagRoot) {
        super.readFromNBT(tagRoot);
        this.colour = tagRoot.getInteger("colour");
        this.lit = tagRoot.getBoolean("lit");
    }

    public void writeToNBT(NBTTagCompound tagRoot) {
        super.writeToNBT(tagRoot);
        tagRoot.setInteger("colour", this.colour);
        tagRoot.setBoolean("lit", this.lit);
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int value) {
        this.colour = value;
    }

    public void addColour(int colour2) {
        int[] myColour = TileCandle.fromIntColour(this.colour);
        int[] addColour = TileCandle.fromIntColour(colour2);
        this.colour = TileCandle.toIntColour((addColour[0] + myColour[0]) / 2, (addColour[0] + myColour[0]) / 2, (addColour[2] + myColour[2]) / 2);
    }

    private static int[] fromIntColour(int value) {
        int[] cs = new int[]{(value & 0xFF0000) >> 16, (value & 0xFF00) >> 8, value & 0xFF};
        return cs;
    }

    private static int toIntColour(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }
}

