/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network;

import forestry.apiculture.tiles.TileCandle;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import java.io.IOException;

public class PacketUpdateCandle
extends PacketCoordinates {
    private int colour;
    private boolean lit;

    public PacketUpdateCandle(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketUpdateCandle(TileCandle tileCandle) {
        super(PacketId.CANDLE, tileCandle);
        this.colour = tileCandle.getColour();
        this.lit = tileCandle.isLit();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeInt(this.colour);
        data.writeBoolean(this.lit);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.colour = data.readInt();
        this.lit = data.readBoolean();
    }

    public int getColour() {
        return this.colour;
    }

    public boolean isLit() {
        return this.lit;
    }
}

