/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.core.utils.vect.Vect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class ItemHabitatLocator
extends ItemInventoried {
    private static final String iconName = "forestry:biomefinder";
    private Set<BiomeGenBase> targetBiomes = new HashSet<BiomeGenBase>();
    private boolean biomeFound = false;
    private int searchRadiusIteration = 0;
    private int searchAngleIteration = 0;
    private Vect searchCenter;
    private static final Set<BiomeGenBase> waterBiomes = new HashSet<BiomeGenBase>();
    private static final Set<BiomeGenBase> netherBiomes = new HashSet<BiomeGenBase>();
    private static final Set<BiomeGenBase> endBiomes = new HashSet<BiomeGenBase>();

    public ItemHabitatLocator() {
        this.setMaxStackSize(1);
        this.setCreativeTab(Tabs.tabApiculture);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.HabitatLocatorGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        if (register instanceof TextureMap) {
            TextureHabitatLocator texture = new TextureHabitatLocator(iconName);
            ((TextureMap)register).setTextureEntry(iconName, (TextureAtlasSprite)texture);
            this.itemIcon = texture;
        }
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        BiomeGenBase currentBiome = player.worldObj.getBiomeGenForCoords((int)player.posX, (int)player.posZ);
        float temperatureValue = currentBiome.getFloatTemperature((int)player.posX, (int)player.posY, (int)player.posZ);
        EnumTemperature temperature = EnumTemperature.getFromValue(temperatureValue);
        EnumHumidity humidity = EnumHumidity.getFromValue(currentBiome.rainfall);
        list.add(StringUtil.localize("gui.currentBiome") + ": " + currentBiome.biomeName);
        list.add(StringUtil.localize("gui.temperature") + ": " + AlleleManager.climateHelper.toDisplay(temperature));
        list.add(StringUtil.localize("gui.humidity") + ": " + AlleleManager.climateHelper.toDisplay(humidity));
    }

    private void startBiomeSearch(IBee bee, EntityPlayer player) {
        this.targetBiomes = new HashSet<BiomeGenBase>(bee.getSuitableBiomes());
        this.searchAngleIteration = 0;
        this.searchRadiusIteration = 0;
        this.biomeFound = false;
        this.searchCenter = new Vect((Entity)player);
        BiomeGenBase currentBiome = player.worldObj.getBiomeGenForCoords(this.searchCenter.x, this.searchCenter.z);
        ItemHabitatLocator.removeInvalidBiomes(currentBiome, this.targetBiomes);
        Proxies.common.setHabitatLocatorCoordinates(null, null);
    }

    public void onUpdate(ItemStack p_77663_1_, World world, Entity player, int p_77663_4_, boolean p_77663_5_) {
        if (world.isRemote) {
            return;
        }
        if (this.targetBiomes.isEmpty()) {
            return;
        }
        if (this.biomeFound && world.getTotalWorldTime() % 20L != 0L) {
            return;
        }
        ChunkCoordinates target = this.findNearestBiome(player, this.targetBiomes);
        if (target != null) {
            Proxies.common.setHabitatLocatorCoordinates(player, target);
            this.biomeFound = true;
        }
    }

    private ChunkCoordinates findNearestBiome(Entity player, Collection<BiomeGenBase> biomesToSearch) {
        int maxChecksPerTick = 100;
        int maxSearchRadiusIterations = 500;
        int spacing = 20;
        Vect playerPos = new Vect(player);
        ChunkCoordinates coordinates = ItemHabitatLocator.getChunkCoordinates(playerPos, player.worldObj, biomesToSearch);
        if (coordinates != null) {
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return new ChunkCoordinates(playerPos.x, playerPos.y, playerPos.z);
        }
        int radius = 20 * (this.searchRadiusIteration + 1);
        double angleSpacing = 2.0 * Math.asin(20.0 / (2.0 * (double)radius));
        angleSpacing = Math.PI * 2 / (double)Math.round(Math.PI * 2 / angleSpacing);
        for (int i = 0; i < 100; ++i) {
            int zOffset;
            double angle = angleSpacing * (double)this.searchAngleIteration;
            if (angle > Math.PI * 2) {
                this.searchAngleIteration = 0;
                ++this.searchRadiusIteration;
                if (this.searchRadiusIteration > 500) {
                    this.searchAngleIteration = 0;
                    this.searchRadiusIteration = 0;
                    this.searchCenter = playerPos;
                }
                return null;
            }
            ++this.searchAngleIteration;
            int xOffset = Math.round((float)((double)radius * Math.cos(angle)));
            Vect pos = this.searchCenter.add(xOffset, 0, zOffset = Math.round((float)((double)radius * Math.sin(angle))));
            coordinates = ItemHabitatLocator.getChunkCoordinates(pos, player.worldObj, biomesToSearch);
            if (coordinates == null) continue;
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return coordinates;
        }
        return null;
    }

    private static ChunkCoordinates getChunkCoordinates(Vect pos, World world, Collection<BiomeGenBase> biomesToSearch) {
        int minBiomeRadius = 8;
        BiomeGenBase biome = world.getBiomeGenForCoords(pos.x, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x - 8, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x + 8, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x, pos.z - 8);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x, pos.z + 8);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        return new ChunkCoordinates(pos.x, pos.y, pos.z);
    }

    private static void removeInvalidBiomes(BiomeGenBase currentBiome, Set<BiomeGenBase> biomesToSearch) {
        biomesToSearch.removeAll(waterBiomes);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            biomesToSearch.retainAll(netherBiomes);
        } else {
            biomesToSearch.removeAll(netherBiomes);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            biomesToSearch.retainAll(endBiomes);
        } else {
            biomesToSearch.removeAll(endBiomes);
        }
    }

    static {
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        Collections.addAll(netherBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        Collections.addAll(endBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END));
    }

    public static class HabitatLocatorInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        private static final short SLOT_ENERGY = 2;
        private static final short SLOT_SPECIMEN = 0;
        private static final short SLOT_ANALYZED = 1;
        private final ItemHabitatLocator habitatLocator;

        public HabitatLocatorInventory(EntityPlayer player, ItemStack itemstack) {
            super(player, 3, itemstack);
            this.habitatLocator = (ItemHabitatLocator)itemstack.getItem();
        }

        private static boolean isEnergy(ItemStack itemstack) {
            if (itemstack == null || itemstack.stackSize <= 0) {
                return false;
            }
            return ForestryItem.honeyDrop.isItemEqual(itemstack) || ForestryItem.honeydew.isItemEqual(itemstack);
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            IBee bee;
            if (this.getStackInSlot(1) != null) {
                if (this.habitatLocator.biomeFound) {
                    return;
                }
            } else if (this.getStackInSlot(0) != null) {
                if (!HabitatLocatorInventory.isEnergy(this.getStackInSlot(2))) {
                    return;
                }
                this.decrStackSize(2, 1);
                this.setInventorySlotContents(1, this.getStackInSlot(0));
                this.setInventorySlotContents(0, null);
            }
            if ((bee = BeeManager.beeRoot.getMember(this.getStackInSlot(1))) == null) {
                return;
            }
            this.habitatLocator.startBiomeSearch(bee, player);
        }

        public Set<BiomeGenBase> getBiomesToSearch() {
            return this.habitatLocator.targetBiomes;
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("habitatlocator") != null && Config.hints.get("habitatlocator").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("habitatlocator");
        }

        @Override
        public ImmutableSet<IErrorState> getErrorStates() {
            if (this.getStackInSlot(1) != null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder errorStates = ImmutableSet.builder();
            ItemStack specimen = this.getStackInSlot(0);
            if (!BeeManager.beeRoot.isMember(specimen)) {
                errorStates.add((Object)EnumErrorCode.NOTHINGANALYZE);
            }
            if (!HabitatLocatorInventory.isEnergy(this.getStackInSlot(2))) {
                errorStates.add((Object)EnumErrorCode.NOHONEY);
            }
            return errorStates.build();
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 2) {
                Item item = itemStack.getItem();
                return item == ForestryItem.honeydew.item() || item == ForestryItem.honeyDrop.item();
            }
            if (slotIndex == 0) {
                return BeeManager.beeRoot.isMember(itemStack);
            }
            return false;
        }
    }
}

