/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.multiblock.IAlvearyController;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.render.EnumTankLevel;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiAlveary
extends GuiForestryTitled<ContainerAlveary, TileAlvearyPlain> {
    public GuiAlveary(InventoryPlayer inventory, TileAlvearyPlain tile) {
        super("textures/gui/alveary.png", new ContainerAlveary(inventory, tile), tile);
        this.ySize = 190;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        IAlvearyController alvearyController = ((TileAlvearyPlain)this.inventory).getAlvearyController();
        this.drawHealthMeter(this.guiLeft + 20, this.guiTop + 37, alvearyController.getHealthScaled(46), EnumTankLevel.rateTankLevel(alvearyController.getHealthScaled(100)));
    }

    private void drawHealthMeter(int x, int y, int height, EnumTankLevel rated) {
        int i = 176;
        int k = 0;
        switch (rated) {
            case EMPTY: {
                break;
            }
            case LOW: {
                i += 4;
                break;
            }
            case MEDIUM: {
                i += 8;
                break;
            }
            case HIGH: {
                i += 12;
                break;
            }
            case MAXIMUM: {
                i += 16;
            }
        }
        this.drawTexturedModalRect(x, y + 46 - height, i, k + 46 - height, 4, height);
    }

    @Override
    protected void initLedgers() {
        super.initLedgers();
        IAlvearyController alvearyController = ((TileAlvearyPlain)this.inventory).getAlvearyController();
        this.ledgerManager.add(new OwnerLedger(this.ledgerManager, alvearyController));
    }
}

