/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProvider
implements IFlowerProvider {
    private final String flowerType;
    private final String description;

    public FlowerProvider(String flowerType, String description) {
        this.flowerType = flowerType;
        this.description = description;
    }

    @Override
    public String getFlowerType() {
        return this.flowerType;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet<EnumPlantType> plantTypes = pollinatable.getPlantType();
        if (this.flowerType.equals("flowersNether")) {
            return plantTypes.contains(EnumPlantType.Nether);
        }
        if (this.flowerType.equals("flowersCacti")) {
            return plantTypes.contains(EnumPlantType.Desert);
        }
        return plantTypes.size() > 1 || !plantTypes.contains(EnumPlantType.Nether);
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        return FlowerManager.flowerRegistry.growFlower(this.flowerType, world, individual, x, y, z);
    }

    @Override
    public String getDescription() {
        return StringUtil.localize(this.description);
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public Set<IFlower> getFlowers() {
        return FlowerManager.flowerRegistry.getAcceptableFlowers(this.flowerType);
    }
}

