/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;

public class EntityFXBee
extends EntityFX {
    public EntityFXBee(World world, double x, double y, double z, int color) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.particleRed = (float)(color >> 16 & 0xFF) / 255.0f;
        this.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        this.particleBlue = (float)(color & 0xFF) / 255.0f;
        this.setSize(0.1f, 0.1f);
        this.particleScale *= 0.2f;
        this.particleMaxAge = (int)(20.0 / (Math.random() * 0.8 + 0.2));
        this.noClip = true;
        this.motionX *= 0.2;
        this.motionY *= 0.015;
        this.motionZ *= 0.2;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= 1.0 + 0.2 * (double)this.rand.nextFloat();
        this.motionY = (this.motionY + 0.2 * (-0.5 + (double)this.rand.nextFloat())) / 2.0;
        this.motionZ *= 1.0 + 0.2 * (double)this.rand.nextFloat();
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        if (this.particleIcon != null) {
            minU = this.particleIcon.getMinU();
            maxU = this.particleIcon.getMaxU();
            minV = this.particleIcon.getMinV();
            maxV = this.particleIcon.getMaxV();
        }
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        tessellator.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, 1.0f);
        tessellator.addVertexWithUV((double)(f11 - f1 * f10 - f4 * f10), (double)(f12 - f2 * f10), (double)(f13 - f3 * f10 - f5 * f10), (double)maxU, (double)maxV);
        tessellator.addVertexWithUV((double)(f11 - f1 * f10 + f4 * f10), (double)(f12 + f2 * f10), (double)(f13 - f3 * f10 + f5 * f10), (double)maxU, (double)minV);
        tessellator.addVertexWithUV((double)(f11 + f1 * f10 + f4 * f10), (double)(f12 + f2 * f10), (double)(f13 + f3 * f10 + f5 * f10), (double)minU, (double)minV);
        tessellator.addVertexWithUV((double)(f11 + f1 * f10 - f4 * f10), (double)(f12 - f2 * f10), (double)(f13 + f3 * f10 - f5 * f10), (double)minU, (double)maxV);
    }

    public int getBrightnessForRender(float partialTicks) {
        return 240;
    }

    public int getFXLayer() {
        return 2;
    }
}

